package mk.ukim.finki.it.reservengo.model;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Admin {
    public Admin(String username, String password, Role userRole) {
        this.username = username;
        this.password = password;
        this.userRole = userRole;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(unique = true)
    private String username;

    private String password;

    @Enumerated(EnumType.STRING)
    private Role userRole = Role.ADMIN;
}
