package mk.ukim.finki.it.reservengo.dto.localDTO;

import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.enumerations.LocalType;

import java.util.List;

public record DisplayLocalDTO(
        Long id,
        String name,
        String description,
        String address,
        String workingHours,
        String logo,
        LocalType localType,
        Double averageRating
) {
    public static DisplayLocalDTO fromLocal(Local local) {
        return new DisplayLocalDTO(
                local.getId(),
                local.getName(),
                local.getDescription(),
                local.getAddress(),
                local.getWorkingHours(),
                local.getLogoUrl(),
                local.getLocalType(),
                local.getAverageRating()
        );
    }

    public static List<DisplayLocalDTO> fromLocals(List<Local> locals) {
        return locals.stream()
                .map(DisplayLocalDTO::fromLocal)
                .toList();
    }
}
