package mk.ukim.finki.it.reservengo.dto.localDTO;

import mk.ukim.finki.it.reservengo.dto.contactDTO.DisplayContactDTO;
import mk.ukim.finki.it.reservengo.dto.eventDTO.DisplayEventDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.enumerations.ProvidedService;

import java.util.List;

public record DisplayLocalDetailsDTO(
        Long id,
        String name,
        String description,
        String address,
        String workingHours,
        List<ProvidedService> services,
        Double ratingAvg,
        List<DisplayEventDTO> events,
        List<String> localPhotos,
        String menuLink,
        DisplayContactDTO contact,
        String logo
) {
    public static DisplayLocalDetailsDTO from(Local local) {
        return new DisplayLocalDetailsDTO(
                local.getId(),
                local.getName(),
                local.getDescription(),
                local.getAddress(),
                local.getWorkingHours(),
                local.getAvailableServices(),
                local.getAverageRating(),
                DisplayEventDTO.fromEvents(local.getEvents()),
                local.getLocalPhotos(),
                local.getMenuLink(),
                DisplayContactDTO.from(local.getContact()),
                local.getLogoUrl()
        );
    }
}
