package mk.ukim.finki.it.reservengo.dto.localDTO;

import mk.ukim.finki.it.reservengo.model.enumerations.LocalType;
import mk.ukim.finki.it.reservengo.model.enumerations.ProvidedService;
import org.springframework.data.domain.Page;


import java.util.List;

public record PagedLocalDTO(
        List<DisplayLocalDTO> local,
        int currentPage,
        int totalPages,
        long itemsPerPage,
        List<ProvidedService> services,
        List<LocalType> localTypes
) {
    public static PagedLocalDTO from(Page<DisplayLocalDTO> page) {
        return new PagedLocalDTO(
                page.getContent(),
                page.getNumber(),
                page.getTotalPages(),
                page.getTotalElements(),
                List.of(ProvidedService.values()),
                List.of(LocalType.values())
        );
    }
}
