export function transformDate(dateTime) {
  let [date, time] = dateTime.split('T')
  let timeSplit = time.split(':')
  time = timeSplit[0] + ':' + timeSplit[1]
  return { date: date, time: time }
}

export function ensureEventDateTime(event) {
  if (!event) return event
  try {
    const start = event?.eventStart
    if (typeof start === 'string' && start.includes('T')) {
      const [datePart, timePartRaw] = start.split('T')
      const timeParts = (timePartRaw || '').split(':')
      const hhmm = timeParts.length >= 2 ? `${timeParts[0]}:${timeParts[1]}` : ''
      if (!event.date) event.date = datePart
      if (!event.time) event.time = hhmm
    } else if (start && typeof start === 'object') {
      if (!event.date && start.date) event.date = start.date
      if (!event.time && start.time) event.time = start.time
    }
  } catch (e) {
  }
  return event
}

export function transformArray(arr, howMany, doDateEdit = true) {
  const copiedArray = JSON.parse(JSON.stringify(arr))

  if (doDateEdit) {
    copiedArray.forEach((item) => {
      item.eventEnd = transformDate(item.eventEnd)
      item.eventStart = transformDate(item.eventStart)
    })
  }

  let newArray = []
  for (let i = 0; i < arr.length; i += howMany) {
    newArray.push(copiedArray.slice(i, i + howMany))
  }
  return newArray
}

export function isValidEmail(email) {
  const emailRegex = new RegExp(
    /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
  )
  return emailRegex.test(email)
}
