package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.model.Customer;
import mk.ukim.finki.it.reservengo.model.Reservation;
import mk.ukim.finki.it.reservengo.model.User;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import mk.ukim.finki.it.reservengo.service.intf.ReservationService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/customer")
@CrossOrigin(origins = "*")
public class CustomerController {

    private final CustomerService customerService;
    private final ReservationService reservationService;

    public CustomerController(CustomerService customerService, ReservationService reservationService) {
        this.customerService = customerService;
        this.reservationService = reservationService;
    }

    @GetMapping
    public ResponseEntity<?> getCustomer() {
        return ResponseEntity.ok("ok");
    }

    @GetMapping("/profile")
    public ResponseEntity<?> getUserProfile(@AuthenticationPrincipal User user) {
        System.out.println(user.getId());
        Customer userProfile = customerService.getCustomerProfile(user.getId());
        return ResponseEntity.ok(userProfile);
    }

    @GetMapping("/reservations")
    public ResponseEntity<?> getCustomerReservations(@AuthenticationPrincipal User user) {
        List<Reservation> customerReservations = reservationService.getCustomerReservations(user.getId());
        return ResponseEntity.ok(customerReservations);
    }
}
