package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import lombok.*;
import mk.ukim.finki.it.reservengo.config.listeners.Auditable;
import mk.ukim.finki.it.reservengo.model.enumerations.EventStatus;
import mk.ukim.finki.it.reservengo.model.enumerations.EventType;

import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Event extends Auditable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @ManyToOne
    private Local local;

    private String name;

    private String description;

    @Enumerated(EnumType.STRING)
    private EventType eventType;

    private LocalDateTime eventStart;

    private LocalDateTime eventEnd;

    public Event(String name, String description, EventType eventType, LocalDateTime eventStart, LocalDateTime eventEnd, Local local) {
        this.name = name;
        this.description = description;
        this.eventType = eventType;
        this.eventStart = eventStart;
        this.eventEnd = eventEnd;
        this.local = local;
    }

    public EventStatus getStatus() {
        LocalDateTime now = LocalDateTime.now();

        if (now.isBefore(eventStart)) {
            return EventStatus.UPCOMING;
        } else if (now.isAfter(eventEnd)) {
            return EventStatus.FINISHED;
        } else {
            return EventStatus.ACTIVE;
        }
    }
}
