package mk.ukim.finki.it.reservengo.dto.eventDTO;

import org.springframework.data.domain.Page;

import java.util.List;

public record PagedEventDTO(
        List<DisplayEventDTO> events,
        int currentPage,
        int totalPages,
        long itemsPerPage
) {
    public static PagedEventDTO from(Page<DisplayEventDTO> page) {
        return new PagedEventDTO(
                page.getContent(),
                page.getNumber(),
                page.getTotalPages(),
                page.getTotalElements()
        );
    }
}
