package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.PagedLocalDTO;
import mk.ukim.finki.it.reservengo.model.enumerations.LocalType;
import mk.ukim.finki.it.reservengo.model.enumerations.ProvidedService;
import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/locals")
public class LocalController {

    private final LocalService localService;

    public LocalController(LocalService localService) {
        this.localService = localService;
    }

    @GetMapping
    public ResponseEntity<PagedLocalDTO> getLocals(
            @RequestParam(required = false) String name,
            @RequestParam(required = false) List<ProvidedService> services,
            @RequestParam(required = false) LocalType localType,
            @RequestParam(required = false) Boolean isOpen,
            @RequestParam(required = false, defaultValue = "name") String sortBy, // created at, rating, name
            @RequestParam(required = false, defaultValue = "asc") String direction,
            @RequestParam(defaultValue = "0") int page,
            @RequestParam(defaultValue = "10") int size
    ) {
        Page<DisplayLocalDTO> dtoPage = localService.searchLocals(name, services, localType, isOpen, page, size, sortBy, direction);
        PagedLocalDTO pagedLocalDTO = PagedLocalDTO.from(dtoPage);
        return new ResponseEntity<>(pagedLocalDTO, HttpStatus.OK);
    }

    @GetMapping("/{id}")
    public ResponseEntity<DisplayLocalDetailsDTO> getLocalDetails(@PathVariable Long id) {
        DisplayLocalDetailsDTO local = DisplayLocalDetailsDTO.from(localService.findLocalById(id));
        return new ResponseEntity<>(local, HttpStatus.OK);
    }
}
