package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.userDTO.*;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.UserService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/api/user")
public class UserController {

    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping("/profile")
    public ResponseEntity<DisplayUserDTO> getProfile(@AuthenticationPrincipal User user) {
        DisplayUserDTO displayUserDTO = DisplayUserDTO.fromUser(userService.findUserById(user.getId()));
        return new ResponseEntity<>(displayUserDTO, HttpStatus.OK);
    }

    @PutMapping("/edit")
    public ResponseEntity<DisplayUserDTO> editProfile(@AuthenticationPrincipal User user, @RequestBody EditUserProfileDTO editUserProfileDTO) {
        return new ResponseEntity<>(userService.editUser(user.getId(), editUserProfileDTO), HttpStatus.OK);
    }

    @PatchMapping("/change-email")
    public ResponseEntity<DisplayUserEmailDTO> changeEmail(@AuthenticationPrincipal User user, @RequestBody EditUserEmailDTO editUserEmailDTO) {
        return new ResponseEntity<>(userService.changeEmail(user.getId(), editUserEmailDTO), HttpStatus.OK);
    }

    @PatchMapping("/change-password")
    public ResponseEntity<Void> changePassword(@AuthenticationPrincipal User user, @RequestBody EditUserPasswordDTO editUserPasswordDTO) {
        userService.changePassword(user.getId(), editUserPasswordDTO);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
