package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.exceptions.UserEmailAlreadyExistsException;
import mk.ukim.finki.it.reservengo.repository.LocalWorkerRepository;
import mk.ukim.finki.it.reservengo.service.intf.LocalWorkerService;
import mk.ukim.finki.it.reservengo.service.intf.UserService;
import org.springframework.stereotype.Service;

@Service
public class LocalWorkerServiceImpl implements LocalWorkerService {
    private final LocalWorkerRepository localWorkerRepository;
    private final UserService userService;

    public LocalWorkerServiceImpl(LocalWorkerRepository localWorkerRepository, UserService userService) {
        this.localWorkerRepository = localWorkerRepository;
        this.userService = userService;
    }

    @Override
    public void save(LocalWorker localWorker) {
        if (userService.emailExists(localWorker.getEmail())) {
            throw new UserEmailAlreadyExistsException(localWorker.getEmail());
        }
        localWorkerRepository.save(localWorker);
    }
}
