package mk.ukim.finki.it.reservengo.dto.reservationDTO;

import mk.ukim.finki.it.reservengo.model.domain.Reservation;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.time.LocalDateTime;
import java.util.List;

public record DisplayReservationDTO(
        String localName,
        String localLogo,
        LocalDateTime timeOfReservation,
        Integer tableNumber,
        Integer capacity,
        ReservationStatus status
) {

    public static DisplayReservationDTO from(Reservation reservation) {
        return new DisplayReservationDTO(
                reservation.getLocal().getName(),
                reservation.getLocal().getLogoUrl(),
                reservation.getTimeOfReservation(),
                reservation.getTable().getTableNumber(),
                reservation.getTable().getCapacity(),
                reservation.getStatus()
        );
    }

    public static List<DisplayReservationDTO> from(List<Reservation> reservations) {
        return reservations.stream()
                .map(DisplayReservationDTO::from)
                .toList();
    }
}
