package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Entity
@AllArgsConstructor
@NoArgsConstructor
@Data
public class DiningTable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Integer tableNumber;
    private Integer capacity;

    @ManyToOne
    private Local local;

    public DiningTable(Integer tableNumber, Integer capacity, Local local) {
        this.tableNumber = tableNumber;
        this.capacity = capacity;
        this.local = local;
    }
}
