package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.dto.tableDTO.TableInfoDTO;
import mk.ukim.finki.it.reservengo.model.domain.DiningTable;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;
import mk.ukim.finki.it.reservengo.repository.ReservationRepository;
import mk.ukim.finki.it.reservengo.repository.TableRepository;
import mk.ukim.finki.it.reservengo.service.intf.TableService;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class TableServiceImpl implements TableService {

    private final TableRepository tableRepository;
    private final ReservationRepository reservationRepository;

    public TableServiceImpl(TableRepository tableRepository, ReservationRepository reservationRepository) {
        this.tableRepository = tableRepository;
        this.reservationRepository = reservationRepository;
    }

    @Override
    public List<TableInfoDTO> getAvailableTables(Long localId, LocalDateTime reservationTime) {
        List<DiningTable> allTables = tableRepository.findByLocalId(localId);

        return allTables.stream()
                .filter(t -> isTableAvailable(t.getId(), reservationTime))
                .map(t -> new TableInfoDTO(t.getId(), t.getTableNumber(), t.getCapacity()))
                .toList();
    }

    @Override
    public boolean isTableAvailable(Long tableId, LocalDateTime reservationTime) {
        return reservationRepository
                .findByTableIdAndTimeOfReservationAndStatusNot(
                        tableId,
                        reservationTime,
                        ReservationStatus.CANCELED
                ).isEmpty();
    }
}
