package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.reservationDTO.CreateReservationDTO;
import mk.ukim.finki.it.reservengo.dto.reservationDTO.DisplayReservationDTO;
import mk.ukim.finki.it.reservengo.dto.reservationDTO.EditReservationDTO;
import mk.ukim.finki.it.reservengo.dto.reservationDTO.EditReservationInfoDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/reservations")
public class ReservationController {

    private final CustomerService customerService;

    public ReservationController(CustomerService customerService) {
        this.customerService = customerService;
    }

    @GetMapping
    public ResponseEntity<List<DisplayReservationDTO>> listCustomerReservations(@AuthenticationPrincipal User user) {
        List<DisplayReservationDTO> allReservation = customerService.listAllReservations(user.getId());
        return new ResponseEntity<>(allReservation, HttpStatus.OK);
    }

    @GetMapping("/{reservationId}")
    public ResponseEntity<DisplayReservationDTO> getReservationDetails(@AuthenticationPrincipal User user, @PathVariable Long reservationId) {
        DisplayReservationDTO reservationDTO = customerService.getReservationPreview(user.getId(), reservationId);
        return new ResponseEntity<>(reservationDTO, HttpStatus.OK);
    }

    @PutMapping("/{reservationId}/cancel")
    public ResponseEntity<Void> cancelReservation(@AuthenticationPrincipal User user, @PathVariable Long reservationId) {
        customerService.cancelReservation(user.getId(), reservationId);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @GetMapping("/{reservationId}/edit-info")
    public ResponseEntity<EditReservationInfoDTO> editReservationInfo(@AuthenticationPrincipal User user, @PathVariable Long reservationId) {
        EditReservationInfoDTO editReservationInfoDTO = customerService.getEditReservationInfo(user.getId(), reservationId);
        return new ResponseEntity<>(editReservationInfoDTO, HttpStatus.OK);
    }

    @PutMapping("/{reservationId}/edit")
    public ResponseEntity<DisplayReservationDTO> editReservation(@AuthenticationPrincipal User user, @PathVariable Long reservationId, @RequestBody EditReservationDTO editReservationDTO) {
        DisplayReservationDTO editedReservationDTO = customerService.editReservation(user.getId(), reservationId, editReservationDTO);
        return new ResponseEntity<>(editedReservationDTO, HttpStatus.OK);
    }

    @PostMapping("/make-reservation")
    public ResponseEntity<DisplayReservationDTO> makeReservation(@AuthenticationPrincipal User user, @RequestBody CreateReservationDTO createReservationDTO) {
        DisplayReservationDTO newReservation = customerService.makeReservation(user.getId(), createReservationDTO);
        return new ResponseEntity<>(newReservation, HttpStatus.OK);
    }
}