// Build API base URL using .env values API_BASE_URL and API_LISTEN_PORT
// Falls back to localhost:8080 if not provided
const RAW_BASE = import.meta.env.API_BASE_URL || import.meta.env.VITE_API_BASE_URL || 'http://localhost'
const RAW_PORT = import.meta.env.API_LISTEN_PORT || import.meta.env.VITE_API_LISTEN_PORT || '8080'

function buildBaseUrl(hostLike, portLike) {
  try {
    // If hostLike already includes protocol, host, and maybe port/path
    const u = new URL(hostLike)
    // If port is not specified in hostLike, apply provided port
    if (!u.port && portLike) {
      u.port = String(portLike)
    }
    return u.origin
  } catch (e) {
    // hostLike might be just a hostname without protocol
    const prefixed = hostLike.startsWith('http') ? hostLike : `http://${hostLike}`
    try {
      const u2 = new URL(prefixed)
      if (!u2.port && portLike) {
        u2.port = String(portLike)
      }
      return u2.origin
    } catch (e2) {
      // Fallback
      return `http://localhost:${portLike || '8080'}`
    }
  }
}

const API_ORIGIN = buildBaseUrl(RAW_BASE, RAW_PORT)



export const config = {
  API_BASE_URL: API_ORIGIN,
  API_LISTEN_PORT: RAW_PORT,
}
console.log("API_ORIGIN",config)
