import { ApiClient } from '@/Api_Classes/ApiClient'
import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class Authentication {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  makeLogin(email: String, password: String) : Promise<any> {
    return this.httpClient.post('login', { email, password })
  }
  makeRegister(
    firstName: String,
    lastName: String,
    email: String,
    phoneNumber: String,
    password: String,
    role: String,
    inviteToken?: String
  ) {
    return this.httpClient.post("register/" + role, { firstName, lastName, email, phoneNumber, password }, {headers: {'Invite-Token': inviteToken} })
  }
  reEnableAccount(email: String, password: String) : Promise<any> {
    return this.httpClient.patch('enable', { email, password })
  }
}

export const useAuth = new Authentication(BASE_API_URL + '/api/auth')
