import 'bootstrap/dist/css/bootstrap.min.css';
import React, {useContext, useEffect, useState} from "react";
import axios from "axios";
import { Link } from 'react-router-dom';
import { useNavigate } from 'react-router-dom';
import {CustomerContext} from "./CustomerContext";


const Customers = () => {
    const [customers, setCustomers] = useState([]);
    const navigate = useNavigate();
    const customersContext = useContext(CustomerContext);

    useEffect(() => {
        setCustomers(customersContext.customers)
    }, [customersContext]);

    const handleDetailClick = (customerId) => {
        navigate(`/customers/${customerId}`);
    }

    const handleEditClick = (customerId) => {
        navigate(`/customers/edit/${customerId}`);
    }

    const handleDeleteClick = async (customerId) => {
        try {
            await axios.delete(`http://localhost:8080/api/customers/delete/${customerId}`);
            setCustomers(customers.filter(customer => customer.customerID !== customerId));
            window.location.reload();
        } catch (error) {
            console.error("Error + " + error);
        }
    }

    return (
        <div className="container mt-4">
            <h1 className="mb-4">Customer List</h1>
            <div className="row row-cols-1 row-cols-md-3 g-4">
                {customers
                    .filter(customer => customer.role !== 'admin')
                    .map((customer) => (
                        <div className="col" key={customer.customerId}>
                            <div className="card h-100">
                                <div className="card-body">
                                    <h5 className="card-title">{customer.fullName}</h5>
                                    <p className="card-text"><strong>Email:</strong> {customer.email}</p>
                                    <p className="card-text"><strong>Phone:</strong> {customer.phone}</p>
                                    <p className="card-text"><strong>Address:</strong> {customer.address}</p>
                                    <p className="card-text"><strong>Membership
                                        Level:</strong> {customer.membershipLevel}</p>
                                    <p className="card-text"><strong>Registration
                                        Date:</strong> {new Date(customer.registrationDate).toLocaleString()}</p>
                                </div>
                                <button onClick={() => handleDetailClick(customer.customerId)}>View Details</button>
                                <button onClick={() => handleEditClick(customer.customerId)}>Edit</button>
                                <button onClick={() => handleDeleteClick(customer.customerId)}>DELETE</button>
                            </div>
                        </div>
                    ))}
            </div>
        </div>
    );

}

export default Customers;