import React, { useEffect, useState } from 'react';
import axios from 'axios';

const MembershipsEnum = () => {
    const [memberships, setMemberships] = useState([]);

    useEffect(() => {
        const fetchMemberships = async () => {
            try {
                const response = await axios.get('http://localhost:8080/api/memberships');
                // Assuming the response.data is an array of enum values
                setMemberships(response.data);
            } catch (error) {
                console.error('Error fetching enum data:', error);
            }
        };

        fetchMemberships();
    }, []);

    return memberships;
};

export default MembershipsEnum;
