import React from 'react';

const StarRating = ({ rating }) => {
    // Convert the rating to a number between 0 and 5
    const normalizedRating = Math.min(Math.max(0, rating), 5);
    // Calculate the number of filled stars
    const filledStars = Math.floor(normalizedRating);
    // Calculate the number of half stars
    const hasHalfStar = normalizedRating - filledStars >= 0.5;

    return (
        <div>
            {[...Array(filledStars)].map((_, index) => (
                <span key={index} className="star">&#9733;</span>
            ))}
            {hasHalfStar && <span className="star">&#9734;</span>}
            {[...Array(5 - filledStars - (hasHalfStar ? 1 : 0))].map((_, index) => (
                <span key={filledStars + index + 1} className="star">&#9734;</span>
            ))}
        </div>
    );
};

export default StarRating;
