package com.example.rezevirajmasa.demo;

import com.example.rezevirajmasa.demo.model.TableEntity;
import com.example.rezevirajmasa.demo.repository.TableRepository;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.annotation.Rollback;

@DataJpaTest
@AutoConfigureTestDatabase(replace = AutoConfigureTestDatabase.Replace.NONE)
@Rollback(false)
public class TableRepositoryTests {
    @Autowired private TableRepository tableRepository;

    @Test
    public void testAddNew() {
        TableEntity tableEntity = new TableEntity();
        tableEntity.setCapacity(2);
        tableEntity.setDescription("Romantic spot");
        tableEntity.setSmokingArea(true);
        tableEntity.setLocation("Big blue");

        TableEntity savedTable = tableRepository.save(tableEntity);
        Assertions.assertThat(savedTable).isNotNull();
        Assertions.assertThat(savedTable.getId()).isGreaterThan(0);
    }
}
