import React from 'react';
import StarRating from "./StarRating";
import MenuList from "./MenuList";

const RestaurantInfo = ({ restaurant }) => {
    return (
        <div className="card-body">
            <h2>
                {restaurant.name} <StarRating key={restaurant.id} rating={restaurant.rating}/>
            </h2>
            <p className="card-text">{restaurant.cuisineType}</p>
            <p className="card-text">{restaurant.operatingHours}</p>
            <p className="card-text">Ul. {restaurant.address}</p>
            <MenuList restaurantId={restaurant.id} />
        </div>
    );
}

export default RestaurantInfo;
