<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Http\Requests\Dashboard\EmailSettingsRequest;
use App\Http\Requests\Dashboard\NewUserRequest;
use App\Http\Requests\Dashboard\PasswordSettingsRequest;
use App\Http\Requests\Dashboard\PhotosSettingsRequest;
use App\Http\Requests\Dashboard\SocialLinksSettingsRequest;
use App\Http\Requests\Dashboard\UpdateUserData;
use App\Http\Requests\Dashboard\UpdateUserRequest;
use App\Http\Requests\Dashboard\UsernameSettingsRequest;
use App\Http\Requests\Dashboard\UserProfileSettingsRequest;
use App\Models\Post;
use App\Models\Role;
use App\Models\User;
use App\Models\UserProfile;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use App\Notifications\VerifyNewEmail;
use Illuminate\Support\Facades\Storage;
use Propaganistas\LaravelPhone\PhoneNumber;
use Propaganistas\LaravelIntl\Facades\Country;

class SettingsController extends Controller
{
    public function settings()
    {
        return view("dashboard.settings.index")->with([
            "user" => auth()->user(),
            "adminAndEditors" => User::where("role_id", 1)->orWhere("role_id", 2)->get()
        ]);
    }

    public function updateUsername(UsernameSettingsRequest $request)
    {
        $user = auth()->user();
        $user->username = $request->username;
        $user->save();

        auth()->logout();
        session()->flush();

        return redirect()->route("auth.loginShow");
    }

    public function updatePassword(PasswordSettingsRequest $request)
    {
        $user = auth()->user();
        $user->password = bcrypt($request->password);
        $user->save();

        auth()->logout();
        session()->flush();

        return redirect()->route("auth.loginShow");
    }

    public function updateEmail(EmailSettingsRequest $request)
    {
        $user = auth()->user();

        $user->email = $request->email;
        $user->is_active = false;
        $user->security_code = $user->generateSecurityCode();
        $user->verify_token = $user->generateVerifyToken();

        $user->save();

        $user->notify(new VerifyNewEmail($user));

        auth()->logout();
        session()->flush();

        return redirect()->route("auth.loginShow");
    }

}
