<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Http\Requests\Dashboard\NewDepartmentRequest;
use App\Http\Requests\Dashboard\UpdateDepartmentRequest;
use App\Models\Department;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DepartmentsController extends Controller
{
    public function index()
    {
        return view("dashboard.departments.index")->with([
            "departments" => Department::all()
        ]);
    }

    public function create()
    {
        return view("dashboard.departments.create");
    }

    public function editShow($id)
    {
        return view("dashboard.departments.edit")->with([
            "department" => Department::findOrFail($id)
        ]);
    }

    public function edit(UpdateDepartmentRequest $request, $id)
    {
        $department = Department::findOrFail($id);

        $department->name = $request->name;
        $department->code = $request->code;

        $department->save();

        Alert::flash("Department edited successfully");

        return redirect()->route("dashboard.departments.index");
    }

    public function store(NewDepartmentRequest $request)
    {
        $department = new Department();

        $department->name = $request->name;
        $department->code = $request->code;

        $department->user_id = auth()->id();

        $department->save();

        Alert::flash("New Department added successfully");

        return redirect()->route("dashboard.departments.index");
    }

    public function destroy(Request $request, $id)
    {
        $department = Department::find($id);

        $department->delete();

        Alert::flash($department->name . " deleted successfully");

        return redirect()->route("dashboard.departments.index");
    }
}
