<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "name" => "required|alpha|min:2|max:255",
            "surname" => "required|alpha|min:2|max:255",
            "mobile_number" => "required|unique:users,mobile_number,$this->id,id",
            "email" => "required|string|email|max:255|unique:users,email,$this->id,id",
            "username" => "required|min:8|unique:users,username,$this->id,id",
            "userRole" => "required|exists:roles,id"
        ];
    }

    protected function getValidatorInstance()
    {

        return parent::getValidatorInstance();
    }
}
