<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Hash;

class PasswordSettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "current_password" => [
                "required",
                function($attribute, $value, $fail) {
                    if(!Hash::check($value, auth()->user()->password)) {
                        $fail("Current password is invalid.");
                    }
                }
            ],
            "password" => "required|string|confirmed|min:8",
        ];
    }
}
