@extends('layouts.app')

@section("title", "Departments")

@section('pageTitle', 'Department List')

@section('head')
    <!-- Datatable -->
    <link rel="stylesheet" href="{{ url('vendors/dataTable/dataTables.min.css') }}" type="text/css">
@endsection

@section('content')

    <div class="page-header justify-content-between">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/departments') }}">Departments</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Departments</li>
            </ol>
        </nav>
        <div class="dropdown">
            <a href="{{ route("dashboard.departments.create") }}" class="btn btn-primary text-white">
                Add department
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="user-list" class="table table-lg">
                            <thead>
                            <tr>
{{--                                <th>--}}
{{--                                    <div class="custom-control custom-checkbox">--}}
{{--                                        <input type="checkbox" class="custom-control-input" id="user-list-select-all">--}}
{{--                                        <label class="custom-control-label" for="user-list-select-all"></label>--}}
{{--                                    </div>--}}
{{--                                </th>--}}
                                <th>ID</th>
                                <th>Name</th>
                                <th>Code</th>
                                <th>Created by</th>
                                <th>Creation date</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($departments as $department)
                                <tr>
                                    <td>{{$department->id }}</td>
                                    <td>{{ $department->name }}</td>
                                    <td>{{ $department->code }}</td>
                                    <td>{{ $department->getCreatedByName() }}</td>
                                    <td>{{ date('d.m.Y', strtotime($department->created_at)) }}</td>
                                    <td>
                                        <a href="{{ route("dashboard.departments.edit", ["id" => $department->id]) }}" class="text-secondary" data-toggle="tooltip" title="Edit">
                                            <i class="ti-pencil"></i>
                                        </a>
                                        <a href="javascript:void(0)" class="text-danger ml-2" data-action="{{ route("dashboard.departments.destroy", ["id" => $department->id]) }}" data-method="delete" title="Delete">
                                            <i class="ti-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <!-- Datatable -->
    <script src="{{ url('vendors/dataTable/dataTables.min.js') }}"></script>

    <script src="{{ url('assets/js/examples/pages/user-list.js') }}"></script>
@endsection
