<?php

namespace App\Http\Controllers\Auth;

use App\Helpers\Alert;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use App\Services\Hashid;

class VerifyLoginController extends Controller
{
    public function index()
    {
        return view("auth.verify-login");
    }

    public function verify(Request $request, Hashid $hashid, $id, $token)
    {
        $user = User::findOrFail($hashid->decode($id));

        if($request->code != $user->security_code) {
            Alert::flash("Security code is wrong", "error");
            return redirect()->back();
        }

        auth()->login($user);

        return redirect()->route("dashboard.index");
    }
}
