<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Models\Department;
use App\Models\Folder;
use App\Models\File;
use App\Models\User;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class IndexController extends Controller
{
    public function index()
    {
        $counters = array(
            "users" => User::count(),
        );

        $date = Carbon::today()->subDays(5);
        $recentFiles = File::where('created_at', '>=', $date)->get();

        $year = ['2021','2022','2023','2024', '2025'];

        $file = [];
        foreach ($year as $key => $value) {
            $file[] = File::where(DB::raw("DATE_FORMAT(created_at, '%Y')"),$value)->count();
        }

        return view("dashboard.index")->with([
            "counters" => $counters,
            "largestDepartments" => Department::orderBy('no_of_folders', 'desc')->limit(10)->get(),
            "folders" => Folder::all(),
            "files" => File::all(),
            "recentFiles" => $recentFiles,
            "year" => json_encode($year,JSON_NUMERIC_CHECK),
            "file" => json_encode($file,JSON_NUMERIC_CHECK),
            "departments" => Department::all(),
            "excelExt" => array("xls", "xlsx", "xls", "csv"),
            "textExt" => array("txt", "doc", "docx"),
            "imageExt" => array("png", "jpg", "jpeg"),

         ]);
    }
}
