<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class ClearAll extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:all {--ms : Do migrate fresh and seed}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear config, cache, view, route';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $ms = $this->option("ms");

        if($ms) {
            Artisan::call("migrate:fresh");
            Artisan::call("db:seed");
        }

        Artisan::call("config:cache");
        Artisan::call("cache:clear");
        Artisan::call("view:clear");
        Artisan::call("route:clear");

        if($ms) {
            $this->info("All data and caches are cleared");
        } else {
            $this->info("All caches are cleared");
        }
    }
}
