@extends('layouts.app')

@section("title", "Documents - Edit document")

@section('pageTitle', 'Edit document')

@section('head')
    <!-- Datatable -->
    <link rel="stylesheet" href="{{ url('vendors/dataTable/dataTables.min.css') }}" type="text/css">
@endsection

@section('content')

    <div class="page-header">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/documents') }}">Documents</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Edit document</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-12">

            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">Documents</h6>
                                    <form action="{{ route("dashboard.documents.edit", ["id" => $document->id]) }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                        @method("patch")
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlSelect1">Department</label>
                                                        <select class="form-control edit_document_deparment" name="department" required>
                                                            @foreach ($departments as $department)
                                                                <option value="{{ $department->id }}" data-dept-code="{{ $department->code }}" {{ old("department", $document->department->id) == $department->id ? "selected" : "" }}>{{ $department->name }}</option>
                                                            @endforeach
                                                        </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Archive ID</label>
                                                    <input type="text" name="arch_id" value="{{ old("arch_id", $document->arch_id) }}" class="form-control" placeholder="Archive ID" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ old("name", $document->name) }}" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Description</label>
                                                    <textarea class="form-control" name="description" rows="3">
                                                        {{ old("description", $document->description) }}
                                                    </textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <input type="file" class="form-control" id="file-item" name="file_item[]" multiple>
                                            </div>
                                        </div>

                                        <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="user-list" class="table table-lg">
                            <thead>
                            <tr>
                                <th></th>
                                <th>ID</th>
                                <th>Size</th>
                                <th>Name</th>
                                <th>Created at</th>
                                <th>Location</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($files as $file)
                                <tr>
                                    <td></td>
                                    <td>{{ $file->id }}</td>
                                    <td>{{ $file->getSize($file->location) }} MB</td>
                                    <td>{{ $file->name }}</td>
                                    <td>{{ date('d.m.Y - H:i', strtotime($file->created_at)) }}</td>
                                <!-- Trigger -->
                                    <td> <span id="copy_{{$department->id}}"></span>
                                        <button class="btn btn-sm btn-primary text-white" data-clipboard-target="#copy_{{ $department->id }}"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clipboard" viewBox="0 0 16 16">
                                                <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/>
                                                <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/>
                                            </svg></button>
                                    </td>
                                    <td>
                                        <a href="javascript:void(0)" class="text-secondary" data-toggle="modal" data-target="#editModal_{{$file->id}}" title="Edit">
                                            <i class="ti-pencil"></i>
                                        </a>
                                        <a href="{{ route("dashboard.documents.downloadFile", $file->id) }}" class="text-secondary" title="Edit">
                                            <i class="ti-download"></i>
                                        </a>
                                        <a href="javascript:void(0)" class="text-danger ml-2" data-toggle="modal" data-target="#deleteModal_{{$file->id}}" title="Delete">
                                            <i class="ti-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <div class="modal fade" id="deleteModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.documents.deleteFile", $file->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <p>Are you sure you want to delete file {{$file->name}}?</p>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                        </button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="editModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Edit department</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.documents.renameFile", ["id" =>$file->id]) }}" method="post" accept-charset="utf-8">
                                                    @method("patch")
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Name</label>
                                                                <input type="text" name="name" value="{{ explode('.', $file->name)[0] }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                                <span>.php</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <input type="submit" value="Save changes" class="btn btn-primary pull-right m-10">
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalCenterTitle">Create department</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <i class="ti-close"></i>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="{{ route("dashboard.departments.store") }}" method="post" accept-charset="utf-8">
                                                @csrf
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>Name</label>
                                                            <input type="text" name="name" value="{{ old('name') }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>Code</label>
                                                            <input type="text" name="code" value="{{ old('code') }}" minlength="2" maxlength="30" class="form-control" placeholder="Code" required>
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                            </form>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script src="{{ url('assets/js/examples/pages/user-list.js') }}"></script>
    <!-- Datatable -->
    <script src="{{ url('vendors/dataTable/dataTables.min.js') }}"></script>
@endsection
