<?php

namespace App\Http\Controllers\Auth;

use App\Http\Requests\Auth\LoginRequest;
use App\Models\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    protected $redirectTo = '/dashboard';

    public function __construct()
    {
        $this->middleware("guest")->except('logout');
    }

    public function showLogin()
    {
        return view("auth.login");
    }

    public function login(LoginRequest $request)
    {
        $user = User::whereUsername($request->username)->first();

        if (!$user->is_active) {
            $request->session()->flash("isActiveError", "Your account is blocked or its not confirmed yet. Please contact with your system administrator or check your email.");
            return redirect()->back();
        }

        if (!Hash::check($request->password, $user->password)) {
            $request->session()->flash("passwordError", "Your password is incorrect");
            return redirect()->back()->withInput($request->input());
        }

        if (auth()->attempt([
            "username" => $request->username,
            "password" => $request->password,
            "is_active" => true], $request->remember)) {

            $user->is_online = true;
            $user->save();

            return redirect()->intended('/dashboard');
        }

        if ($user->is_forgot_password) {
            $user->is_forgot_password = false;
        }

        $request->session()->flash("loginError", "An error occurred while login. Please try again later.");

        return redirect()->back()->withInput($request->input());
    }

    public function logout()
    {

        $user = auth()->user();
        $user->is_online = false;
        $user->save();

        auth()->logout();

        return redirect("/auth/login");
    }
}
