<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CreatePasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $that = $this;

        return [
            "password" => "required|string|confirmed|min:8",
            "security_code" => [
                "required",
                "integer",
                Rule::exists("users")->where(function ($query) use ($that) {
                    $query->where("id", $that->route("id"));
                }),
            ]
        ];
    }
}
