@extends('layouts.app')

@section("title", "SaveSpace - Files")

@section('head')

@endsection

@section('content')

    <div class="page-header justify-content-between">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('/') }}">Dashboard</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Files</li>
            </ol>
        </nav>
        <div class="dropdown">
            @if(auth()->user()->hasPermission('manage_all_files'))
            <a href="javascript:void(0)" data-toggle="modal" data-target="#createModal" class="btn btn-primary text-white">
                <i class="fa fa-upload pr-1"></i> Upload
            </a>
            @endif
            @if(auth()->user()->hasPermission('download_data'))
            <a href="{{ route("dashboard.departments.downloadAll") }}" class="btn btn-danger text-white">
                <i class="fa fa-download pr-1"></i> Download
            </a>
            @endif
            @if(auth()->user()->hasPermission('export_data'))
            <a href="{{ route('dashboard.files.export') }}" class="btn btn-success text-white">
                <i class="fa fa-table pr-1"></i> Export
            </a>
                @endif
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="user-list" class="table table-lg">
                            <thead>
                            <tr>
                                <th>
                                </th>
                                <th>Image</th>
                                <th>Name</th>
                                <th>Created at</th>
                                <th>Updated at</th>
                                <th>Folder name</th>
                                <th>Folder archive ID</th>
                                <th>Directory</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($files as $file)
                                <tr>
                                    <td></td>
                                    <td>
                                        @if(in_array(explode('.', $file->name)[1], $excelExt))
                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                            <i class="fa fa-file-excel-o text-success fa-2x"></i>
                                            </div>
                                        @else @if(in_array(explode('.', $file->name)[1], $textExt))
                                            <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                            <i class="fa fa-file-word-o text-info fa-2x"></i>
                                            </div>
                                        @else @if(explode('.', $file->name)[1] == 'pdf')
                                                <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                <i class="fa fa-file-pdf-o text-danger fa-2x"></i>
                                                </div>
                                            @else @if(in_array(explode('.', $file->name)[1], $imageExt))
{{--                                                    <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">--}}
{{--                                                        <a href="{{ url('/storage/' . $file->location) }}" class="image-popup-gallery-item">--}}
{{--                                                            <div class="image-hover">--}}
{{--                                                                <img src="{{ url('/storage/' . $file->location) }}" class="rounded" width="30" alt="image">--}}
{{--                                                            </div>--}}
{{--                                                        </a>--}}
{{--                                                    </div>--}}
                                                    <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                        <i class="fa fa-file-image-o text-danger fa-2x"></i>
                                                    </div>
                                                @else
                                                    <div class="col-xl-1 col-lg-1 col-md-1 col-sm-2">
                                                    <i class="fa fa-file-text-o text-warning fa-2x"></i>
                                                    </div>
                                                @endif
                                            @endif
                                            @endif
                                            @endif


                                    </td>
                                    <td>{{ $file->name }}</td>
                                    <td>{{ date('d.m.Y - H:i', strtotime($file->created_at)) }}</td>
                                    @if($file->updated_at==NULL)
                                        <td>/</td>
                                    @else
                                        <td>{{ date('d.m.Y - H:i', strtotime($file->updated_at)) }}</td>
                                @endif
                                    <td><a href="{{ route('dashboard.folders.files', ['id' => $file->folder_id]) }}" class="text-linkedin">{{ \App\Models\Folder::find($file->folder_id)->name }}</a></td>
                                    <td>{{ \App\Models\Folder::find($file->folder_id)->arch_id }}</td>
                                <!-- Trigger -->
                                    <td><button data-clipboard-text="{{$file->location}}" class="btn btn-sm btn-primary text-white" data-toggle="tooltip" data-placement="right" title="{{$file->location}}"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clipboard" viewBox="0 0 16 16">
                                                <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/>
                                                <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/>
                                            </svg></button>
                                    </td>
                                    @if(auth()->user()->hasPermission('manage_all_files'))
                                    <td>
                                        <a href="javascript:void(0)" class="text-secondary" data-toggle="modal" data-target="#editModal_{{$file->id}}" title="Edit">
                                            <i class="ti-pencil"></i>
                                        </a>
                                        <a href="{{ route("dashboard.files.downloadFile", ['id' => $file->id]) }}" class="text-danger ml-2"title="Download">
                                            <i class="ti-download"></i>
                                        </a>
                                        <a href="javascript:void(0)" class="text-danger ml-2" data-toggle="modal" data-target="#deleteModal_{{$file->id}}" title="Delete">
                                            <i class="ti-trash"></i>
                                        </a>
                                    </td>
                                    @else
                                <td></td>
                                        @endif
                                </tr>
                                <div class="modal fade" id="deleteModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.files.deleteFile", $file->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <p>Are you sure you want to delete file {{$file->name}}?</p>
                                                    <p>Location: <span class="pr-1">{{$file->location}}</span></p>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                        </button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="editModal_{{$file->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Rename file</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.files.renameFile", ["id" =>$file->id]) }}" method="post" accept-charset="utf-8">
                                                    @method("patch")
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label class="form-label">Current name: {{$file->name}}</label>
                                                                <input type="text" name="name" value="{{ explode('.', $file->name)[0] }}" maxlength="255" title="Don't include: '\/.|'" pattern="^[^.\/|]+$" class="form-control" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <br/>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                        </button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            </tbody>
                        </table>

                        <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalCenterTitle">Upload</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <i class="ti-close"></i>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <form action="{{ route("dashboard.files.store") }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                            @csrf
                                            <div class="row">
                                                <div class="col-md-10">
                                                    <div class="form-group">
                                                        <label for="exampleFormControlSelect1">Folder</label>
                                                        @if($folders->count())
                                                            <select class="form-control" name="folder" required>
                                                                @foreach ($folders as $folder)
                                                                    <option value="{{ $folder->id }}" {{ (old("folder") == $folder->id ? "selected" : "") }}>{{ $folder->name }}</option>
                                                                @endforeach
                                                                @else
                                                                    <p>You haven't created any folders yet. <a class="text-primary" href="{{ route("dashboard.folders.index") }}">Create now.</a></p>
                                                                @endif
                                                            </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-10">
                                                    <div class="form-group">
                                                        <label for="exampleFormControlSelect1">Uploads</label>


                                                    <input type="file" class="form-control" id="file-item" name="file_item[]" accept="{{ $fileTypes }}" multiple>
                                                    </div>
                                                </div>
                                            </div>
                                            <br/>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                </button>
                                                <button type="submit" class="btn btn-primary">Save changes</button>
                                            </div>
                                        </form>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')

    @yield('script')

    <script src="{{ url('assets/js/examples/pages/user-list.js') }}"></script>
@endsection
