<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Http\Requests\Dashboard\EmailSettingsRequest;
use App\Http\Requests\Dashboard\FileTypeRequest;
use App\Http\Requests\Dashboard\PasswordSettingsRequest;
use App\Http\Requests\Dashboard\UsernameSettingsRequest;
use App\Models\FileType;
use App\Models\User;
use App\Http\Controllers\Controller;
use App\Notifications\VerifyNewEmail;
use Carbon\Carbon;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class SettingsController extends Controller
{
    public function settings()
    {
        return view("dashboard.settings.index")->with([
            "user" => auth()->user(),
            "active_tab" => "account",
            "fileType" => FileType::find("1")
        ]);
    }

    public function updateUsername(UsernameSettingsRequest $request)
    {
            $user = auth()->user();
            $user->username = $request->username;
            $user->updated_at = Carbon::now();
            $user->save();

            Alert::flash("Username updated successfully");

            auth()->logout();
            session()->flush();

            return redirect()->route("auth.showLogin");
    }

    public function updatePassword(PasswordSettingsRequest $request)
    {
            $user = auth()->user();
            $user->password = bcrypt($request->password);
            $user->updated_at = Carbon::now();
            $user->save();

            Alert::flash("Password updated successfully");

            auth()->logout();
            session()->flush();

            return redirect()->route("auth.showLogin");
    }

    public function updateEmail(EmailSettingsRequest $request)
    {
        $user = auth()->user();

        $user->email = $request->email;
        $user->is_active = false;
        $user->security_code = $user->generateSecurityCode();
        $user->verify_token = $user->generateVerifyToken();
        $user->updated_at = Carbon::now();

        $user->save();

        $user->notify(new VerifyNewEmail($user));

        Alert::flash("Email updated successfully");

        auth()->logout();
        session()->flush();

        return redirect()->route("auth.showLogin");
    }

    public function fileTypes(FileTypeRequest $request)
    {
        $fileType = FileType::find("1");

        $fileType->mimes = $request->mimes;
        $fileType->max_size = $request->max_size;
        $fileType->user_id = auth()->id();
        $fileType->updated_at = Carbon::now();

        if(auth()->user()->hasPermission("manage_file_types")) {
            $fileType->save();

            Alert::flash("File validations updated successfully");

            return redirect()->back();
        }
        else {
            Alert::flash("You don't have permission to change file validations", "error");

            return redirect()->back();
        }
    }

}
