<?php

namespace App\Exports;

use App\Models\Role;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UsersExport implements FromCollection, WithMapping, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return User::all();
    }

    public function map($row): array{
        $fields = [
            $row->id,
            $row->name,
            $row->surname,
            $row->username,
            $row->email,
            $row->phone_number,
            $row->is_confirmed,
            $row->role_id . ' - ' . Role::find($row->role_id)->name,
            $row->where('id', $row->created_by)->pluck('username')->first(),
            $row->created_at,
            $row->updated_at,
            $row->avatar,
        ];
        return $fields;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Name',
            'Surname',
            'Username',
            'Email',
            'Phone number',
            'Is confirmed',
            'Role ID - Username',
            'Created by',
            'Created at',
            'Updated at',
            'Avatar'
        ];
    }
}
