<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Http\Controllers\Controller;
use App\Http\Requests\Dashboard\FileNameRequest;
use App\Http\Requests\Dashboard\FileRequest;
use App\Models\FileType;
use App\Models\Folder;
use App\Models\File;
use App\Models\User;
use App\Notifications\NewFileCreated;
use Carbon\Carbon;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Storage;

class FilesController extends Controller
{
    public function index ()
    {
        return view("dashboard.files.index")->with([
            "files" => File::all(),
            "folders" => Folder::all(),
            "excelExt" => array("xls", "xlsx", "xls", "csv"),
            "textExt" => array("txt", "doc", "docx"),
            "imageExt" => array("png", "jpg", "jpeg"),
            "fileTypes" => '.' . implode(',.', explode(',', FileType::find('1')->mimes))
        ]);
    }

    public function deleteFile($id)
    {
        $file = File::find($id);
        $file->delete();
        Storage::disk('local')->delete($file->location);
        $file->folder()->decrement('no_of_files');

        Alert::flash($file->name . " deleted successfully");

        return redirect()->back();
    }

    public function store(FileRequest $request)
    {
        $file = new File();

        $folder = Folder::find($request->folder);

        $location = $folder->location;

        $users = User::all();

        if ($request->has('file_item')) {
            foreach ($request->file_item as $file) {
                $fileName = $file->getClientOriginalName();

                if(File::where(['folder_id' => $folder->id, 'name' => $fileName])->count() > 0) {
                    Alert::flash("The uploaded file already exists", "error");

                    return redirect()->back();
                }

                $file->storeAs($location . DIRECTORY_SEPARATOR, $fileName);
                $newFile = new File();
                $newFile->name = $fileName;
                $newFile->location = $location . DIRECTORY_SEPARATOR . $fileName;
                $newFile->folder()->associate($folder);
                $newFile->folder()->increment('no_of_files');
                $newFile->save();
            }

            Alert::flash("New files added successfully");

            return redirect()->back();
        }
        else {
            Alert::flash("No files were uploaded", "error");

            return redirect()->back();
        }
    }

    public function downloadFile($id)
    {
        $file = File::find($id);
        return Storage::download($file->location);
    }
}
