@extends('layouts.app')

@section("title", "Documents - Edit document")

@section('pageTitle', 'Edit document')

@section('content')

    <div class="page-header">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/documents') }}">Documents</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Edit document</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-12">

            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title">Documents</h6>
                                    <form action="{{ route("dashboard.documents.edit", ["id" => $document->id]) }}" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                                        @method("patch")
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="exampleFormControlSelect1">Department</label>
                                                        <select class="form-control edit_document_deparment" name="department" required>
                                                            @foreach ($departments as $department)
                                                                <option value="{{ $department->id }}" {{ old("department", $document->department->id) == $department->id ? "selected" : "" }}>{{ $department->name }}</option>
                                                            @endforeach
                                                        </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Archive ID</label>
                                                    <input type="text" name="arch_id" value="{{ old("arch_id", $document->arch_id) }}" class="form-control" placeholder="Archive ID" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Name</label>
                                                    <input type="text" name="name" value="{{ old("name", $document->name) }}" class="form-control" placeholder="Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Description</label>
                                                    <textarea class="form-control" name="description" rows="3">
                                                        {{ old("description", $document->description) }}
                                                    </textarea>
                                                </div>
                                            </div>
                                        </div>


                                        <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
