<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\Alert;
use App\Models\Department;
use App\Models\Folder;
use App\Models\File;
use App\Models\User;
use App\Http\Controllers\Controller;

class IndexController extends Controller
{
    public function index()
    {
        $counters = array(
            "users" => User::count(),
        );

        return view("dashboard.index")->with([
            "counters" => $counters,
            "departments" => Department::all(),
            "folders" => Folder::all(),
            "files" => File::all()
        ]);
    }
}
