<?php

namespace App\Exports;

use App\Models\File;
use App\Models\Folder;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class FilesExport implements FromCollection,  WithMapping, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return File::all();
    }

    public function map($row): array{
        $fields = [
            $row->id,
            $row->name,
            $row->location,
            $row->getSize($row->location) . ' MB',
            $row->Folder::find($row->folder_id)->name . ' - ' . Folder::find($row->folder_id)->arch_id,
            $row->created_at,
            $row->updated_at
        ];
        return $fields;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Name',
            'Location',
            'Size',
            'Folder - Archive ID',
            'Created at',
            'Updated at'
        ];
    }
}
