<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\User;
use Illuminate\Support\Carbon;

class CheckCreatePassword
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $id = $request->route("id");
        $token = $request->route("token");

        $user = User::findOrFail($id);

        if($user->is_active) {
            return redirect()->route("auth.showLogin");
        }

        if(!$user->is_forgot_password) {
            if(Carbon::now()->greaterThan($user->created_at->addMinutes(180))) {
                return redirect()->route("auth.showLogin");
            }
        }

        return $next($request);
    }
}
