<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class File extends Model
{
    use HasFactory;

    protected $table = "files";
    protected $fillable = ["name", "location", "folder_id"];

    public function folder()
    {
        return $this->belongsTo(Folder::class);
    }

    public function getSize($location)
    {
        $fileSize = Storage::disk('local')->size($location) / 1024 / 1024;
        $fileSize = round($fileSize, 2);
        return $fileSize;
    }
}
