@extends('layouts.app')

@section("title", "SaveSpace - Documents")

@section('pageTitle', 'SaveSpace - Documents')

@section('content')

    <div class="row app-block mb-4">
        <div class="col-md-3 app-sidebar">
            <div class="card">
                <div class="card-body">
                    <a href="{{ route("dashboard.documents.create") }}" class="btn btn-secondary btn-block file-upload-btn text-white" data-action="{{ route("dashboard.documents.create") }}">
                        Add document
                    </a>
                    <form class="d-none" id="file-upload">
                        <input type="file" multiple>
                    </form>
                </div>
                <div class="app-sidebar-menu">
                    <div class="list-group list-group-flush">
                        <a href="{{route("dashboard.documents.index")}}" class="list-group-item d-flex align-items-center">
                            <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                            Documents
{{--                            <span class="small ml-auto">{{$totalDocs}}</span>--}}
                        </a>
                        @foreach($departments as $department)
                            <a href="{{ route("dashboard.documents.index", ["id" => $department->id]) }}" class="list-group-item d-flex align-items-center">
                                <i data-feather="folder" class="width-15 height-15 mr-2"></i>
                                {{$department->name}}
                                <span class="small ml-auto">{{$department->document->count()}}</span>
                            </a>
                        @endforeach
                        <a href="{{ URL::current()."?sort=recent" }}" class="list-group-item">
                            <i data-feather="upload-cloud" class="width-15 height-15 mr-2"></i>
                            Recents
                        </a>
                        <a href="{{ URL::current()."?sort=important" }}" class="list-group-item d-flex align-items-center">
                            <i data-feather="star" class="width-15 height-15 mr-2"></i>
                            Important
                            <span class="small ml-auto">{{ $countImportant }}</span>
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="mb-4">Storage Status</h6>
                        <div class="d-flex align-items-center">
                            <div class="mr-3">
                                <i data-feather="database" class="width-30 height-30"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="progress" style="height: 10px">
                                    <div class="progress-bar progress-bar-striped" role="progressbar"
                                         style="width: {{$diskUse}}" aria-valuenow="10" aria-valuemin="0"
                                         aria-valuemax="100"></div>
                                        <span class="sr-only">{{$diskUse}}</span>
                                </div>
                                <div class="line-height-12 small text-muted mt-2">{{round($diskUsedSize,2)}} GB /
                                    {{round($diskTotalSize,2)}} GB ({{$diskUse}})</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-md-9 app-content">
            <div class="app-content-overlay"></div>
            <div class="app-action">
                <div class="action-left">
                    <ul class="list-inline">
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                                <i data-feather="plus" class="mr-1"></i>
                                Add
                            </a>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="{{route("dashboard.departments.create")}}">Department</a>
                                <a class="dropdown-item" href="{{route("dashboard.documents.create")}}">Document</a>
                            </div>
                        </li>
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">Departments</a>
                            <div class="dropdown-menu">
                                @foreach($departments as $department)
                                    <a class="dropdown-item d-flex justify-content-between m-5" href="{{ route("dashboard.documents.index", ["id" => $department->id]) }}">
                                        {{$department->name}}
                                        <span class="text-muted">{{$department->document->count()}}</span>
                                    </a>
                                @endforeach
                            </div>
                        </li>
                        <li class="list-inline-item mb-0">
                            <a href="#" class="btn btn-outline-light dropdown-toggle" data-toggle="dropdown">
                                Order by
                            </a>
                            <div class="dropdown-menu">
                                @if(Request::get('id'))
                                    <a class="dropdown-item" href="{{ URL::current()."?id=".Request::get('id')."&sort=newest" }}">Date</a>
                                    <a class="dropdown-item" href="{{ URL::current()."?id=".Request::get('id')."&sort=name" }}">Name</a>
                                    <a class="dropdown-item" href="#">Size</a>
                                @else
                                    <a class="dropdown-item" href="{{ URL::current()."?sort=newest" }}">Date</a>
                                    <a class="dropdown-item" href="{{ URL::current()."?sort=name" }}">Name</a>
                                    <a class="dropdown-item" href="#">Size - not done</a>
                                @endif
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="action-right">
                    <form action="{{ route("dashboard.documents.index") }}" method="get" class="d-flex mr-3">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Search file"
                                   aria-describedby="button-addon1" required>
                            <div class="input-group-append">
                                <button class="btn btn-outline-light searchSubmitBtn" type="submit" value="Search">
                                    <i data-feather="search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <p>Documents</p>
            <div class="row">
                @forelse($documents as $document)
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">
                        <div class="card app-file-list">
                            <div class="app-file-icon">
                                <i class="fa fa-file-text-o text-primary"></i>
                                <div class="dropdown position-absolute top-0 right-0 mr-3">
                                    <a href="#" class="btn btn-outline-light btn-sm" data-toggle="dropdown">
                                        <i class="fa fa-ellipsis-h"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        <a href="{{ route("dashboard.documents.edit", ["id" => $document->id]) }}" class="dropdown-item">View Details</a>
                                        <a href="#" class="dropdown-item">Share</a>
                                        <a href="#" class="dropdown-item">Download</a>
                                        <button class="dropdown-item action-dropdown-item"
                                           href="javascript:void(0)" onclick="toggleImportant({{$document->id}})">
                                            @if($document->is_important)
                                                Mark as not important
                                            @else
                                                Mark as important
                                            @endif
                                        </button>
                                        <a href="javascript:void(0)" class="dropdown-item" data-toggle="modal" data-target="#deleteModal_{{$document->id}}">Delete</a>
                                    </div>
                                </div>
                            </div>
                            <div class="p-2 small">
                                @if($document->is_important)
                                    <div>{{$document->name}} - {{$document->arch_id}} <i class="fa fa-star" style="color:orange"></i></div>
                                @else
                                    <div>{{$document->name}} - {{$document->arch_id}} </div>
                                @endif
                                <div>{{$document->created_at}}</div>
                                <div class="text-muted">{{$document->description}}</div>
                                <div class="text-muted">1.2MB</div>
                            </div>
                        </div>
                    </div>
                    <form id="toggleImportant_{{ $document->id }}"
                          action="{{ route("dashboard.documents.toggleImportant", ["id" => $document->id]) }}"
                          method="post">
                        @csrf
                        @method("patch")
                    </form>
                    <div class="modal fade" id="deleteModal_{{$document->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route("dashboard.documents.destroy", $document->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <p>Are you sure you want to delete document {{$document->name}} with Archive ID: {{ $document->arch_id }}?</p>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-12">No items found</div>
                @endforelse

            </div>
             @if(!Request::query('search'))
             {{$documents->appends($_GET)->links('layouts.pagination') }}
                 @endif
    </div>

@endsection

@section('script')

<script>
    function toggleImportant(id) {
        document.getElementById('toggleImportant_' + id).submit();
    }
</script>

@endsection
