<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;



class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \DB::table('permissions')->insert([
            ["name" => "create_user"], 				// Create new user
            ["name" => "manage_all_users"], 		// Access all users to manage
            ["name" => "manage_all_departments"], 	// Access all departments to manage
            ["name" => "manage_all_documents"], 	// Access all documents to manage
            ["name" => "view_all_departments"], 	// Access all departments to view
            ["name" => "view_all_documents"], 	    // Access all documents to view
            ["name" => "edit_all_documents"], 		// Edit all documents
            ["name" => "edit_document"], 		    // Edit your document/s
            ["name" => "delete_all_documents"], 	// Delete all document/s
            ["name" => "delete_document"], 	        // Delete your document/s
            ["name" => "manage_file_types"], 	// Access all file_types to manage
        ]);
    }
}
