@extends('layouts.app')

@section("title", "SaveSpace - Departments")

@section('pageTitle', 'Departments')

@section('head')
    <!-- Datatable -->
    <link rel="stylesheet" href="{{ url('vendors/dataTable/dataTables.min.css') }}" type="text/css">
@endsection

@section('content')

    <div class="page-header justify-content-between">
        <nav aria-label="breadcrumb" class="d-flex align-items-start">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('dashboard/departments') }}">Departments</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Departments</li>
            </ol>
        </nav>
        <div class="dropdown">
            <a href="javascript:void(0)" data-toggle="modal" data-target="#createModal" class="btn btn-primary text-white">
                Add department
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="user-list" class="table table-lg">
                            <thead>
                            <tr>
                                <th>
                                </th>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Code</th>
                                <th>Created by</th>
                                <th>Created at</th>
                                <th>Updated at</th>
                                <th>Directory</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($departments as $department)
                                <tr>
                                    <td></td>
                                    <td>{{$department->id }}</td>
                                    <td>{{ $department->name }}</td>
                                    <td>{{ $department->code }}</td>
                                    <td>{{ $department->getCreatedByName() }}</td>
                                    <td>{{ date('d.m.Y - H:i', strtotime($department->created_at)) }}</td>
                                    @if($department->updated_at==NULL)
                                        <td>/</td>
                                    @else
                                    <td>{{ date('d.m.Y - H:i', strtotime($department->updated_at)) }}</td>
                                    @endif
                                    <!-- Trigger -->
                                    <td>{{ $department->location }}
                                            <button class="btn btn-sm btn-primary text-white" data-clipboard-target="#copy_{{ $department->id }}"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clipboard" viewBox="0 0 16 16">
                                                    <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"/>
                                                    <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"/>
                                                </svg></button>
                                        <span type="hidden" id="copy_{{$department->id}}"></span>
                                    </td>
                                    <td>
                                        <a href="javascript:void(0)" class="text-secondary" data-toggle="modal" data-target="#editModal_{{$department->id}}" title="Edit">
                                            <i class="ti-pencil"></i>
                                        </a>
                                        <a href="javascript:void(0)" class="text-danger ml-2" data-toggle="modal" data-target="#deleteModal_{{$department->id}}" title="Delete">
                                            <i class="ti-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <div class="modal fade" id="deleteModal_{{$department->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Delete confirmation</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.departments.destroy", $department->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <p>Are you sure you want to delete department {{$department->name}} with code: {{$department->code}}?</p>
                                                    <p>Number of documents associated: {{$department->document()->count()}}</p>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close
                                                        </button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="editModal_{{$department->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Edit department</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <i class="ti-close"></i>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route("dashboard.departments.edit", ["id" =>$department->id]) }}" method="post" accept-charset="utf-8">
                                                    @method("patch")
                                                    @csrf
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Name</label>
                                                                <input type="text" name="name" value="{{ $department->name }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="form-label">Code</label>
                                                                <input type="text" name="code" value="{{ $department->code }}" minlength="2" maxlength="30" class="form-control" placeholder="Code" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <input type="submit" value="Save changes" class="btn btn-primary pull-right m-10">
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalCenterTitle">Create department</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <i class="ti-close"></i>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="{{ route("dashboard.departments.store") }}" method="post" accept-charset="utf-8">
                                                @csrf
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>Name</label>
                                                            <input type="text" name="name" value="{{ old('name') }}" minlength="2" maxlength="30" class="form-control" placeholder="Name" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>Code</label>
                                                            <input type="text" name="code" value="{{ old('code') }}" minlength="2" maxlength="30" class="form-control" placeholder="Code" required>
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="submit" value="Save changes" class="submitBtn btn btn-primary pull-right m-10">
                                            </form>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script src="{{ url('assets/js/examples/pages/user-list.js') }}"></script>
    <!-- Datatable -->
    <script src="{{ url('vendors/dataTable/dataTables.min.js') }}"></script>
@endsection
