@extends('layouts.auth')

@section("title", "SaveSpace - Forgot")

@section('content')

    <!-- logo -->
    <div id="logo">
        <img class="logo" src="{{ url('assets/media/images/logo.png') }}" alt="image">
    </div>
    <!-- ./ logo -->

    <h5>Reset password</h5>

    <!-- form -->
    <form action="{{ route("auth.forgot") }}" method="post">
        @csrf
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="m-0 pl-2">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if(Session::has('forgotInfo'))
            <div class="alert alert-success fade show" role="alert">
                <strong> {{ Session::get('forgotInfo') }} </strong>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                </button>
            </div>
        @endif
        <div class="form-group">
            <input type="email" name="email" class="form-control" id="" aria-describedby="emailHelp" placeholder="Username" required autofocus>
        </div>
        <button type="submit" class="btn btn-primary btn-block">Submit</button>
        <hr>
        <p class="text-muted">Take a different action.</p>
        <a href="{{ route("auth.loginShow") }}" class="btn btn-sm btn-outline-light ml-1">Login!</a>
    </form>
    <!-- ./ form -->

@endsection
