$(document).ready(function() {
    var companies = {};

    $.ajax({
       url: "http://localhost:8080/api/business"
    }).then(function (data) {
        companies = data;
        var $el = $("#table_body");

        $.each(data, function (index, obj) {
            if(obj.businessStatus == "NEW" || obj.businessStatus == "DEACTIVATED") {
                $el.append("<tr>\n" +
                    "            <th scope=\"row\">" + obj.id + "</th>\n" +
                    "            <td>" + obj.companyName + "</td>\n" +
                    "            <td>" + obj.owner.firstName + " " + obj.owner.lastName + "</td>\n" +
                    "            <td><input class=\"form-check-input\" type=\"checkbox\" value=\"" + obj.id +"\"></td>\n" +
                    "        </tr>")
            }
            if (obj.businessStatus == "ACTIVE") {
                $el.append("<tr>\n" +
                    "            <th scope=\"row\">" + obj.id + "</th>\n" +
                    "            <td>" + obj.companyName + "</td>\n" +
                    "            <td>" + obj.owner.firstName + " " + obj.owner.lastName + "</td>\n" +
                    "            <td><input class=\"form-check-input\" type=\"checkbox\" checked value=\"" + obj.id +"\"></td>\n" +
                    "        </tr>")
            }
        });
    });

    $('#save_button').click(function () {
        $.each($('#table_body tr'), function(index, row) {
            if(companies[index].businessStatus == "NEW" &&  $($($(row).children() [3]).children()[0]).is(':checked')) {
                companies[index]['businessStatus'] = 'ACTIVE';
            }
            if(companies[index].businessStatus == "ACTIVE" && ! $($($(row).children() [3]).children()[0]).is(':checked')) {
                companies[index]['businessStatus'] = 'DEACTIVATED';
            }
        });
        console.log(JSON.stringify(companies));
        $.ajax({
            url: "http://localhost:8080/api/business",
            type:"PATCH",
            data: JSON.stringify(companies),
            contentType:"application/json; charset=utf-8",
            dataType: 'text',
            success: function(succ){
                alert( "Updates applied successfully" );
            },
            error: function(err) {
                alert(err);
            }
        });
        event.preventDefault();
    });
});