SET search_path TO project;

-- University
INSERT INTO University (Name, Location, IsPrivate) VALUES
('University of Skopje', 'Skopje', FALSE),
('Private Tech University', 'Bitola', TRUE);

-- Faculty
INSERT INTO Faculty (Name, Location, study_field, University_Id) VALUES
('Faculty of Computer Science', 'Skopje', 'ENGINEERING', 1),
('Faculty of Economics', 'Skopje', 'SCIENCE', 1),
('Faculty of Engineering', 'Bitola', 'ENGINEERING', 2);

-- Professor
INSERT INTO Professor (Name, Surname, Age, Faculty_Id) VALUES
('Ivan', 'Petrov', 45, 1),
('Ana', 'Markoska', 38, 2),
('Boris', 'Stojanov', 50, 3);

-- Student
INSERT INTO Student (Name, Surname, Location, Student_Index, Faculty_Id) VALUES
('Elena', 'Georgieva', 'Skopje', 12345, 1),
('Marko', 'Trajkov', 'Skopje', 12346, 2),
('Petar', 'Ivanov', 'Bitola', 12347, 3);

-- Subject
INSERT INTO Subject (Name, Semester, Credits, Faculty_Id) VALUES
('Databases', 1, 6, 1),
('Economics 101', 2, 5, 2),
('Engineering Basics', 1, 4, 3);

-- Subject_Professor
INSERT INTO Subject_Professor (Subject_Id, Professor_Id) VALUES
(1, 1),
(2, 2),
(3, 3);

-- Student_Subject
INSERT INTO Student_Subject (Student_Id, Subject_Id, Final_Grade, Status, Enrollment_Date, Absences_Count) VALUES
(1, 1, 10, 'PASSED', '2026-01-10', 0),
(2, 2, 9, 'PASSED', '2026-01-12', 2),
(3, 3, NULL, 'ENROLLED', '2026-01-15', 0);

-- Advice: students with their advisers
INSERT INTO Advice (Student_Id, Professor_Id, Start_Date, End_Date) VALUES
(1, 1, '2026-01-01', '2026-06-30'),  -- Elena advised by Ivan
(2, 2, '2026-01-01', '2026-06-30'),  -- Marko advised by Ana
(3, 3, '2026-01-01', '2026-06-30');  -- Petar advised by Boris

-- Affiliated: professors affiliated with universities
INSERT INTO Affiliated (University_Id, Professor_Id) VALUES
(1, 1),  -- Ivan affiliated with University of Skopje
(1, 2),  -- Ana affiliated with University of Skopje
(2, 3);  -- Boris affiliated with Private Tech University

