INSERT INTO course (title_short,
                    title,
                    description_short,
                    description,
                    description_long,
                    difficulty,
                    duration_minutes,
                    price,
                    image_url,
                    color)
VALUES ('Foundations for a Successful Business & Career',
        'Building New Paradigm / Perception & Perspective as Foundations for a Successful Business and Professional Career',
        'Understand how paradigms, perception, and perspective shape your business and career success.',
        'Explore how paradigms shape your thinking, and how perception and perspective impact your professional and personal growth. In this course, you’ll uncover why shifting these mental models is crucial for unlocking new opportunities and overcoming hidden barriers. You’ll also learn how to use these concepts to build a resilient foundation that supports confident decision-making and continuous improvement in business and career contexts.',
        'This comprehensive course deeply explores the powerful concepts of paradigms, perception, and perspective as they relate to business and professional growth. You''ll gain a thorough understanding of what paradigms are — deeply ingrained mental frameworks that shape how you interpret and interact with the world around you. You''ll learn how perception (your interpretation of external events) and perspective (your angle or approach) are interconnected and influence every decision and action you take. We examine common pitfalls that professionals encounter when they hold rigid paradigms or outdated perspectives, preventing them from adapting to change and seizing opportunities. Through practical exercises, real-life case studies, and reflective assessments, you''ll learn how to identify and reframe limiting paradigms to adopt a growth-oriented mindset that supports continuous improvement. You''ll explore advanced strategies to strengthen self-awareness and emotional intelligence, crucial skills for leadership and personal development. Additionally, we delve into subtle but critical differences between perception and perspective and how misalignment can undermine even the most skilled professionals. By the end of this course, you''ll have a robust framework for self-assessment and practical tools to shift your mental models, enhance decision-making, and achieve sustainable success in your business and career.',
        'BEGINNER', 221, 0,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751286550/Foundations_for_a_Successful_Business_Career_k8vcuu.jpg',
        '#02C2FF'),

       ('From Manager to Leader',
        'From Manager to Leader: Empowering People, Managing Processes',
        'Transform your managerial skills into effective leadership.',
        'Learn how to shift from simply managing tasks to truly leading with purpose and clarity. In this course, you will explore leadership mindsets, communication strategies, and practical tools to empower your team, foster accountability, and create a motivating environment. You will also understand how to balance responsibility and delegation while cultivating a strong culture of trust and performance within your organization.',
        'This course is designed for managers who aspire to become impactful leaders capable of driving both people and processes to success. You''ll learn about generative leadership and the 3xH''s model (Head, Heart, and Hands), which helps leaders balance logic, emotion, and action. Discover the fundamental differences between responsibility and guilt, and how to build a strong foundation for team accountability. The course covers vital communication strategies, effective feedback methods, and advanced delegation skills, ensuring that you empower rather than micromanage your team. You''ll explore leadership models like AB, Min/Max, and SMART objectives to clarify goals and expectations. Practical scenarios and real-world case studies will help you understand common challenges faced by managers as they step into leadership roles, including breaking organizational silos and fostering cross-functional collaboration. Additionally, you will learn how to mentor and develop future leaders, cultivate a culture of trust and innovation, and handle difficult conversations with grace. By the end, you''ll possess a complete toolkit to inspire, guide, and lead with confidence and authenticity, making you a true catalyst for organizational success.',
        'INTERMEDIATE', 242, 29,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/From_Manager_to_Leader_-_Empowering_People_Managing_Processes_vgoyoh.webp',
        '#19C6D6'),

       ('Business Transformation Blueprint',
        'Business Transformation Blueprint: Crafting the Path to Success',
        'Design and implement successful business transformations.',
        'Master a detailed, step-by-step framework designed to guide your business through structured, sustainable transformation. In this course, you will learn how to align teams around a clear purpose, engage middle management, establish effective KPIs, and implement change initiatives that ensure long-term resilience and growth. Discover how to create agile structures and overcome resistance to change with confidence.',
        'This course serves as a complete roadmap for leaders and strategists who want to guide their organizations through impactful, sustainable transformation. You will learn how to recognize when transformation is necessary, understand its drivers, and define a clear purpose and direction. The program unpacks the six essential stages of transformation: from establishing a powerful purpose to developing robust KPIs that measure progress and success. You''ll explore the pivotal role middle management plays as both champions and gatekeepers of change, and how to effectively engage them in the process. Through detailed exploration of each transformation stage, you will understand the importance of sequential execution to avoid chaos and resistance. The course also emphasizes building agile and resilient organizational structures that can adapt to market changes while maintaining long-term stability and sustainability. Real-world examples and case studies provide insights into overcoming common pitfalls, such as stakeholder misalignment and cultural resistance. By integrating new paradigms and perspectives, you''ll empower your business to achieve unmatched levels of stability, agility, resilience, and sustainability. By the end, you''ll have the strategic and operational tools to design and execute transformative initiatives that create enduring business success.',
        'ADVANCED', 239, 54,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Business_Transformation_Blueprint_-_Crafting_the_Path_to_Success_aimssk.jpg',
        '#1FB0C3'),

       ('SME Business Roadmap',
        'Business Roadmap for SME’s: A Step-by-Step Guide for Establishing Core Business Foundations for Sustainable Growth',
        'Step-by-step guidance for SMEs to build solid business foundations.',
        'Gain a practical, step-by-step approach to building strong business foundations for your SME. This course helps you navigate information overload, focus on what truly matters, and set up systems that promote stability, agility, and sustainable growth. You will also learn how to align your team around a shared vision and build long-term strategies that empower you to grow confidently and strategically.',
        'In today''s information-saturated world, small and medium-sized enterprises often face an overwhelming number of business growth strategies, marketing advice, and conflicting success frameworks. This course is designed to eliminate that confusion and provide a structured, practical approach to building a solid business foundation. You''ll learn how to clearly define your purpose, align your team, and develop a strategic plan that ensures long-term success. The course introduces a new paradigm and expanded perspective to help you focus on what truly matters for sustainable growth. You''ll explore how to achieve stability, agility, resilience, and sustainability by applying tried-and-tested models and frameworks tailored for SMEs. Detailed modules will guide you through core business functions including operations, sales, marketing, finance, and HR, ensuring every area supports your overall strategic vision. You will also learn how to evaluate and improve organizational efficiency, establish clear KPIs, and build a culture of continuous improvement. Real-world case studies and hands-on exercises will help solidify these concepts, empowering you to navigate uncertainty with clarity and confidence. By the end, you''ll have a complete step-by-step guide to transform your SME into a thriving, future-proof business.',
        'INTERMEDIATE', 165, 50,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Business_Roadmap_for_SME_s_-_A_Step-by-Step_Guide_for_Establishing_Core_Business_Foundations_for_Sustainable_Growth_qeejox.jpg',
        '#002E5D'),

       ('Sales Masterclass',
        'Sales Masterclass: Leadership, Communication, and Modern Sales Process',
        'Master modern sales strategies, leadership, and communication.',
        'Unlock a comprehensive roadmap to mastering modern sales processes, leadership, and communication. You will learn advanced techniques to build high-performance sales teams, foster synergy, improve negotiation outcomes, and cultivate a growth-focused mindset. This course empowers you to close deals confidently, inspire your team, and consistently exceed sales targets in a rapidly changing market.',
        'This comprehensive sales masterclass is designed for professionals who want to stand out and excel in today''s dynamic and client-centric market. You''ll gain in-depth insights into the roles of frontline salespeople and sales leaders, understanding how to create synergy and high-performance teams. Learn the critical difference between being responsible and feeling guilty and how this affects your sales mindset and resilience. Explore how organizational silos negatively impact sales efficiency and how to overcome them to foster seamless collaboration. You''ll study advanced time management techniques tailored for sales environments, and understand what truly defines high-performance behaviors and results. The course covers essential negotiation strategies, modern communication techniques, and practical leadership tools like the AB model, helping you build stronger client relationships and close deals with greater success. Through practical examples, exercises, and case studies, you''ll develop a powerful mix of technical skills and soft skills necessary for outstanding sales performance. By the end of the course, you will have the confidence, strategic understanding, and practical tools to lead in sales, exceed targets consistently, and build a long-lasting, client-centered career.',
        'ADVANCED', 240, 29,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Sales_Masterclass_-_Leadership_Communication_and_Modern_Sales_Process_v74qdh.webp',
        '#034D4C'),

       ('Mastering Success Skills',
        'From Good to Extraordinary: Mastering Skills for Success',
        'Unlock your full potential with practical skills for extraordinary success.',
        'Develop essential skills to move from being good to truly extraordinary in your personal and professional life. In this course, you’ll explore powerful frameworks for time management, decision-making, and expectation management, as well as cognitive and behavioral tools that enhance overall effectiveness. Learn how to create impactful habits, improve communication, and unlock new levels of personal growth and achievement.',
        'This holistic course is designed for individuals and professionals who want to elevate their effectiveness, mindset, and results. You''ll explore essential topics such as perception, time management, managing expectations, and setting smart priorities. Through practical frameworks like the AB model, Min/Max analysis, SMART objectives, and the method of deduction, you''ll learn to improve decision-making, enhance efficiency, and boost overall performance. The course also emphasizes cognitive skills development, communication maturity, and how to handle high-pressure situations with confidence. You''ll master meeting productivity, strategic thinking, and personal effectiveness in real-world scenarios. By engaging in reflective exercises and practical activities, you''ll uncover hidden habits that limit your potential and replace them with proactive, empowering behaviors. Real-world case studies and success stories illustrate how these skills can transform your professional journey from merely good to truly extraordinary. By the end of this course, you will possess a robust toolkit for achieving outstanding results, strengthening relationships, and continuously advancing both personally and professionally.',
        'INTERMEDIATE', 197, 35,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751032528/From_Good_to_Extraordinary_-_Mastering_Skills_for_Success_fm0io9.webp',
        '#D0B8A3'),

       ('Winning Markets in 3 Steps',
        'Winning Markets in 3 Steps: Building a Clear Go-to-Market Strategy',
        'Build a clear, effective go-to-market strategy in just 3 steps.',
        'Learn to build a clear and highly effective go-to-market strategy in three actionable steps. You will discover how to identify and understand your ideal client profile, define precise messaging, and choose the best channels to reach them. By applying practical tools and real-world examples, you’ll gain the confidence and clarity needed to succeed in even the most competitive markets.',
        'Without a clear marketing strategy, businesses often drift without focus and waste resources. This course introduces a straightforward, three-step approach to creating a highly effective go-to-market strategy. You will learn how to define your ideal target client using eight key characteristics: needs, wants, expectations, challenges, fears, intentions, prejudices, and opportunities. Next, you will master how to determine the right timing, channels, and messaging to reach and engage your audience most effectively. The course includes strategic tools like the AB model and a quantitative negotiation method, enabling you to make data-driven and confident decisions. You will also explore how to build strong value propositions and design a compelling customer journey that increases conversion and loyalty. Real-world case studies and practical exercises will help you directly apply these concepts to your business. By the end of this course, you will have a clear, actionable, and winning strategy that strengthens market positioning, drives revenue, and supports long-term growth.',
        'INTERMEDIATE', 206, 29,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Winning_Markets_in_3_Steps_-_Building_a_Clear_Go-to-Market_Strategy_vayg15.png',
        '#FF6F61'),

       ('How to Create Added Value',
        'Creating Added Value: How to Offer Solutions/Concepts, Instead of Services',
        'Shift from selling services to offering impactful solutions and concepts.',
        'Learn how to move beyond selling services and start offering impactful solutions and strategic concepts that create true value for your clients. This course helps you understand your clients'' real needs, develop offers that solve deeper problems, and position yourself as a trusted strategic partner. Gain the skills to design solutions that resonate and drive long-term business relationships.',
        'In this course, you will learn how to move beyond selling services to providing impactful solutions and long-term concepts that generate true value. You will understand the critical differences between selling a service, providing a solution, and developing a concept — and why moving to solutions and concepts unlocks higher client loyalty and market differentiation. You will learn to deeply analyze your target audience, identify real problems they face, and design solutions that directly address those needs. The course covers techniques for developing strong value propositions, strategic storytelling, and crafting offers that resonate with clients on both functional and emotional levels. Using practical examples, including the iconic Nescafe Frape concept, you will see how theory transforms into actionable business models. You will also explore frameworks to ensure your solutions are scalable and sustainable, and how to create offers that position you as a strategic partner rather than just a service provider. By the end of this course, you will have a clear roadmap to build offers that inspire, engage, and create lasting value for your clients and your business.',
        'INTERMEDIATE', 203, 29,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Creating_Added_Value_-_How_to_Offer_SolutionsConcepts_Instead_of_Services_z9fs3c.png',
        '#F5AD01'),

       ('Seamless Onboarding Strategy',
        'Onboarding Fundamentals: How to Successfully Incorporate New Employees',
        'Master the essentials of onboarding to boost retention and employee satisfaction.',
        'Discover how to design an onboarding experience that helps new employees integrate quickly and successfully into your organization. You’ll learn to create a structured onboarding plan that enhances engagement, clarifies expectations, and improves long-term retention. This course provides practical strategies and tools to ensure new hires feel confident, motivated, and fully prepared to contribute from day one.',
        'Effective onboarding is essential for ensuring new employees feel confident, welcomed, and prepared to succeed. This course covers how to build a structured onboarding journey that integrates new hires smoothly into your company culture and operational workflow. You will learn to design clear role expectations, create pre-boarding materials, and organize first-week activities that build strong initial connections. The course also provides strategies for extending onboarding beyond the first weeks to reinforce learning, encourage engagement, and foster long-term retention. You will explore templates and feedback loops that help continuously improve the onboarding process. By using real-world examples and practical exercises, you will be able to avoid common pitfalls that lead to disengagement and turnover. By the end, you will have the skills and resources to design a seamless onboarding experience that strengthens employee satisfaction, boosts retention, and supports overall organizational success.',
        'BEGINNER', 141, 25,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Onboarding_Fundamentals_-_How_to_Successfully_Incorporate_New_Employees_bksbad.png',
        '#008CC2'),

       ('Growth Through Self-Assessment',
        'Professional Self-Assessment: Identify Barriers Holding You Back & Areas for Improvement',
        'Use self-assessment tools to unlock growth and overcome personal barriers.',
        'Unlock your growth potential by learning to evaluate your strengths and weaknesses using proven self-assessment methods. This course guides you through frameworks for understanding what holds you back, helps you set actionable improvement goals, and empowers you to create a roadmap for professional and personal development. Gain clarity and build the confidence needed to achieve sustained growth.',
        'This course provides a step-by-step approach to understanding and improving your professional effectiveness. You will explore self-assessment techniques such as performance evaluations, needs analysis, and the method of deduction to uncover hidden patterns in your behavior and mindset. The course emphasizes practical applications that help you turn self-reflection into actionable growth strategies. You will learn how to identify barriers holding you back, develop clear action plans to overcome them, and set measurable goals for continuous improvement. Additionally, you will explore the importance of seeking feedback from peers and mentors to enhance self-awareness and accountability. Through exercises, case studies, and personal reflection, you will gain the tools to improve decision-making, boost confidence, and advance your career more strategically. By the end of the course, you will have a comprehensive self-development roadmap, empowering you to achieve personal and professional breakthroughs and realize your full potential.',
        'BEGINNER', 154, 25,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Professional_Self-Assessment_-_Identify_Barriers_Holding_You_Back_Areas_for_Improvement_tiyydc.jpg',
        '#CC6232'),

       ('Business Excellence Blueprint',
        'Establishing Continuous Business Excellence in Your Company',
        'Create a high-performance culture through proven excellence frameworks.',
        'Discover how to embed operational excellence and continuous improvement deeply into your organization. Learn to align teams, set impactful goals, streamline communication, and create systems that support high performance and growth. This course equips you with practical models and real-world strategies to build a culture of excellence that drives long-term competitive advantage.',
        'This course is designed to help leaders and professionals embed a culture of excellence and continuous improvement across their organizations. You will explore powerful models including the Effective Meetings Model, AB model, DF model, and pre/post evaluation frameworks to improve alignment and accountability. The course guides you through mapping organizational disproportions, streamlining communication, and fostering cross-functional collaboration. You will learn to set clear goals, establish robust KPIs, and create feedback loops that reinforce progress and drive sustained success. Real-world examples and case studies show how to navigate resistance to change and build momentum for new initiatives. You will also develop strategies for ensuring long-term adoption of excellence practices and integrating them into the daily rhythm of the organization. By the end of the course, you will possess the mindset, frameworks, and tools needed to transform your organization into a resilient, agile, and continuously improving enterprise, capable of maintaining a competitive edge in any market.',
        'ADVANCED', 161, 39,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028998/Establishing_Continuous_Business_Excellence_in_Your_Company_g3yvao.png',
        '#18898D'),

       ('Organizational Success Through Structure',
        'High-Performing Teams and Systems: Organizational Success Through Structure',
        'Build efficient, structured teams and systems that drive sustainable organizational success.',
        'Learn to build strong, structured teams and efficient systems that drive organizational success and growth. This course teaches you how to break down silos, improve collaboration, clarify team roles, and establish accountability structures. Gain the skills to design organizational systems that promote agility, optimize performance, and create a foundation for long-term sustainability and resilience.',
        'This course provides a comprehensive guide to creating high-performing teams and building structured systems that drive organizational success. You will learn how to develop systematic approaches to team design, clarify roles and responsibilities, and eliminate inefficiencies caused by miscommunication and silos. The course covers essential practices for aligning teams with organizational goals, improving collaboration, and establishing strong accountability mechanisms. You will also explore frameworks for effective meetings, conflict resolution, and strategic decision-making that help maintain cohesion and high performance. Using practical exercises and case studies, you will learn to diagnose structural bottlenecks and design solutions that enable scalability and agility. By the end, you will have the knowledge and skills to build robust organizational structures that support continuous improvement, empower teams to excel, and sustain competitive advantage in a dynamic business environment.',
        'INTERMEDIATE', 165, 32,
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/High-Performing_Teams_and_Systems_-_Organizational_Success_Through_Structure_b6jvm5.jpg',
        '#FF9503');


INSERT INTO course_skills_gained (course_id, skills_gained)
VALUES
-- 1. Building New Paradigm / Perception & Perspective
(1, 'PARADIGM_UNDERSTANDING'),
(1, 'PERCEPTION_MANAGEMENT'),
(1, 'PERSPECTIVE_SHIFTING'),

-- 2. From Manager to Leader
(2, 'LEADERSHIP'),
(2, 'DELEGATION'),
(2, 'DECISION_MAKING'),
(2, 'PEOPLE_MANAGEMENT'),

-- 3. Business Transformation Blueprint
(3, 'STRATEGIC_PLANNING'),
(3, 'CHANGE_MANAGEMENT'),
(3, 'PROJECT_MANAGEMENT'),
(3, 'RISK_MANAGEMENT'),

-- 4. Business Roadmap for SME’s
(4, 'BUSINESS_MODEL_CREATION'),
(4, 'STRATEGIC_THINKING'),
(4, 'OPERATION_MANAGEMENT'),

-- 5. Sales Masterclass
(5, 'SALES'),
(5, 'COMMUNICATION'),
(5, 'NEGOTIATION'),
(5, 'LEADERSHIP'),

-- 6. From Good to Extraordinary
(6, 'COMMUNICATION'),
(6, 'DECISION_MAKING'),
(6, 'CRITICAL_THINKING'),
(6, 'EMOTIONAL_INTELLIGENCE'),

-- 7. Winning Markets in 3 Steps
(7, 'MARKETING'),
(7, 'SALES'),
(7, 'STRATEGIC_THINKING'),

-- 8. Creating Added Value
(8, 'OPPORTUNITY_IDENTIFICATION'),
(8, 'INNOVATION_MANAGEMENT'),
(8, 'MARKETING'),

-- 9. Onboarding Fundamentals
(9, 'PEOPLE_MANAGEMENT'),
(9, 'TEAM_BUILDING'),
(9, 'COMMUNICATION'),

-- 10. Professional Self-Assessment
(10, 'EMOTIONAL_INTELLIGENCE'),
(10, 'CRITICAL_THINKING'),
(10, 'COMMUNICATION'),

-- 11. Establishing Continuous Business Excellence
(11, 'PROJECT_MANAGEMENT'),
(11, 'PERFORMANCE_EVALUATION'),
(11, 'CHANGE_MANAGEMENT'),
(11, 'STRATEGIC_PLANNING'),

-- 12. High-Performing Teams and Systems
(12, 'TEAM_BUILDING'),
(12, 'OPERATION_MANAGEMENT'),
(12, 'PEOPLE_MANAGEMENT'),
(12, 'PERFORMANCE_EVALUATION');


INSERT INTO course_topics_covered (course_id, topics_covered)
VALUES
-- 1. Building New Paradigm / Perception & Perspective
(1, 'PARADIGM_CONCEPTS'),
(1, 'PERCEPTION_AND_PERSPECTIVE'),
(1, 'BUSINESS_AND_CAREER_FOUNDATIONS'),

-- 2. From Manager to Leader
(2, 'LEADERSHIP'),
(2, 'MANAGEMENT'),
(2, 'COMMUNICATION'),
(2, 'TEAM_DEVELOPMENT'),
(2, 'DECISION_MAKING'),

-- 3. Business Transformation Blueprint
(3, 'BUSINESS_TRANSFORMATION'),
(3, 'DIGITAL_TRANSFORMATION'),
(3, 'CHANGE_MANAGEMENT'),
(3, 'STRATEGIC_PLANNING'),
(3, 'AGILITY'),

-- 4. Business Roadmap for SME’s
(4, 'ENTREPRENEURSHIP'),
(4, 'STARTUP_METHODS'),
(4, 'BUSINESS_TRANSFORMATION'),
(4, 'STRATEGIC_PLANNING'),
(4, 'OPERATIONAL_EXCELLENCE'),

-- 5. Sales Masterclass
(5, 'SALES_STRATEGIES'),
(5, 'NEGOTIATION'),
(5, 'LEADERSHIP'),
(5, 'COMMUNICATION'),
(5, 'CLIENT_RELATIONSHIPS'),

-- 6. From Good to Extraordinary
(6, 'PERSONAL_GROWTH'),
(6, 'LEADERSHIP'),
(6, 'COMMUNICATION'),
(6, 'TIME_MANAGEMENT'),
(6, 'DECISION_MAKING'),

-- 7. Winning Markets in 3 Steps
(7, 'SALES_STRATEGIES'),
(7, 'VALUE_CREATION'),
(7, 'MARKETING'),
(7, 'GO_TO_MARKET_STRATEGY'),
(7, 'CLIENT_TARGETING'),

-- 8. Creating Added Value
(8, 'MARKETING'),
(8, 'SALES'),
(8, 'VALUE_CREATION'),
(8, 'BUSINESS_INNOVATION'),
(8, 'CLIENT_TARGETING'),

-- 9. Onboarding Fundamentals
(9, 'HR'),
(9, 'MANAGEMENT'),
(9, 'LEADERSHIP'),
(9, 'CULTURE_INTEGRATION'),
(9, 'TEAM_OPTIMIZATION'),

-- 10. Professional Self-Assessment
(10, 'PERSONAL_GROWTH'),
(10, 'LEADERSHIP'),
(10, 'SELF_AWARENESS'),
(10, 'PERFORMANCE_IMPROVEMENT'),
(10, 'TIME_MANAGEMENT'),

-- 11. Establishing Continuous Business Excellence
(11, 'MANAGEMENT'),
(11, 'TIME_MANAGEMENT'),
(11, 'BUSINESS_TRANSFORMATION'),
(11, 'CONTINUOUS_IMPROVEMENT'),
(11, 'STRATEGIC_PLANNING'),
(11, 'AGILITY'),

-- 12. High-Performing Teams and Systems
(12, 'MANAGEMENT'),
(12, 'LEADERSHIP'),
(12, 'BUSINESS_TRANSFORMATION'),
(12, 'TEAM_OPTIMIZATION'),
(12, 'SYSTEM_DESIGN');

INSERT INTO course_what_will_be_learned (course_id, what_will_be_learned)
VALUES
-- 1. Building New Paradigm / Perception & Perspective
(1, 'Understand how paradigms shape your business and personal decisions.'),
(1, 'Learn to identify limiting beliefs and reframe them for growth.'),
(1, 'Explore the differences between perception and perspective and their impact.'),
(1, 'Develop skills to challenge and shift outdated mental models.'),
(1, 'Enhance emotional intelligence and self-awareness for leadership success.'),
(1, 'Adopt a growth-oriented mindset to unlock new opportunities.'),
(1, 'Build resilience through deeper self-understanding and perspective shifts.'),
(1, 'Apply practical tools to improve decision-making and personal growth.'),
(1, 'Strengthen your ability to adapt and thrive in changing environments.'),
(1, 'Create a personal framework for continuous improvement and success.'),

-- 2. From Manager to Leader
(2, 'Transition from task-focused management to inspiring leadership.'),
(2, 'Learn how to empower and motivate diverse teams.'),
(2, 'Master effective delegation to build trust and accountability.'),
(2, 'Strengthen communication and feedback skills for team alignment.'),
(2, 'Understand the balance between responsibility and guilt in leadership.'),
(2, 'Develop coaching and mentoring skills for future leaders.'),
(2, 'Create a culture of trust, innovation, and high performance.'),
(2, 'Handle difficult conversations with confidence and empathy.'),
(2, 'Break organizational silos to foster collaboration.'),
(2, 'Use strategic models to set clear objectives and drive results.'),

-- 3. Business Transformation Blueprint
(3, 'Identify when and why business transformation is necessary.'),
(3, 'Establish a clear purpose and strategic direction for change.'),
(3, 'Develop and implement effective KPIs to measure progress.'),
(3, 'Engage middle management as champions of transformation.'),
(3, 'Overcome resistance and ensure stakeholder alignment.'),
(3, 'Design agile organizational structures for long-term success.'),
(3, 'Sequence transformation stages to avoid chaos and confusion.'),
(3, 'Build resilience and adaptability within the organization.'),
(3, 'Learn from real-world case studies and practical frameworks.'),
(3, 'Create a sustainable roadmap for continuous improvement and growth.'),

-- 4. Business Roadmap for SME’s
(4, 'Define a clear and compelling business purpose for your SME.'),
(4, 'Align your team around shared goals and a unified vision.'),
(4, 'Develop strategic plans focused on sustainable growth.'),
(4, 'Set up practical systems to support stability and agility.'),
(4, 'Integrate core functions like marketing, sales, and finance effectively.'),
(4, 'Establish clear KPIs and performance measurement tools.'),
(4, 'Foster a culture of continuous improvement and adaptability.'),
(4, 'Simplify decision-making in an information-overloaded environment.'),
(4, 'Learn to navigate uncertainty with confidence and clarity.'),
(4, 'Build a long-term strategy for a future-proof business foundation.'),

-- 5. Sales Masterclass
(5, 'Master modern sales processes and high-impact selling techniques.'),
(5, 'Understand the dynamics between salespeople and sales leaders.'),
(5, 'Foster synergy and high performance within sales teams.'),
(5, 'Improve negotiation outcomes through strategic communication.'),
(5, 'Overcome silos to create seamless customer experiences.'),
(5, 'Build a resilient and growth-focused sales mindset.'),
(5, 'Strengthen time management specifically for sales contexts.'),
(5, 'Develop stronger client relationships for long-term success.'),
(5, 'Leverage advanced leadership models to inspire sales teams.'),
(5, 'Consistently exceed sales targets in dynamic market environments.'),

-- 6. From Good to Extraordinary
(6, 'Develop a growth mindset to elevate personal and professional success.'),
(6, 'Master time management and priority-setting for higher productivity.'),
(6, 'Enhance decision-making skills through practical frameworks.'),
(6, 'Cultivate impactful habits that drive extraordinary results.'),
(6, 'Strengthen communication and interpersonal effectiveness.'),
(6, 'Navigate high-pressure situations with confidence and control.'),
(6, 'Identify and transform limiting behaviors and mindsets.'),
(6, 'Apply cognitive and behavioral tools for continuous improvement.'),
(6, 'Learn to run effective meetings and manage expectations.'),
(6, 'Build a strategic approach to achieve outstanding long-term outcomes.'),

-- 7. Winning Markets in 3 Steps
(7, 'Define and analyze your ideal target client profile precisely.'),
(7, 'Craft clear and compelling messaging tailored to your audience.'),
(7, 'Select the most effective channels to reach your clients.'),
(7, 'Build a strong value proposition that resonates and converts.'),
(7, 'Design a compelling customer journey for improved engagement.'),
(7, 'Apply strategic tools to support data-driven marketing decisions.'),
(7, 'Develop a clear and actionable go-to-market roadmap.'),
(7, 'Strengthen market positioning for competitive advantage.'),
(7, 'Increase conversion rates and build client loyalty effectively.'),
(7, 'Gain the confidence to launch and scale successful market strategies.'),

-- 8. Creating Added Value
(8, 'Understand the differences between services, solutions, and concepts.'),
(8, 'Analyze client needs to design impactful solutions.'),
(8, 'Develop offers that create long-term client loyalty.'),
(8, 'Craft strong value propositions and strategic storytelling.'),
(8, 'Position yourself as a trusted strategic partner, not just a service provider.'),
(8, 'Ensure your offers are scalable and sustainable over time.'),
(8, 'Learn frameworks to transition from services to solutions.'),
(8, 'Master concept-based selling to stand out in the market.'),
(8, 'Incorporate practical examples like the Nescafe Frape concept.'),
(8, 'Build offers that resonate emotionally and functionally with clients.'),

-- 9. Onboarding Fundamentals
(9, 'Design effective onboarding experiences tailored to each role.'),
(9, 'Create pre-boarding materials to prepare new hires early.'),
(9, 'Organize first-week activities that build strong connections.'),
(9, 'Clarify expectations and reduce early-stage confusion.'),
(9, 'Foster engagement and motivation from day one.'),
(9, 'Extend onboarding to reinforce learning and integration.'),
(9, 'Implement feedback loops to improve onboarding processes.'),
(9, 'Avoid common pitfalls that cause disengagement and turnover.'),
(9, 'Strengthen employee satisfaction and long-term retention.'),
(9, 'Build a foundation for confident, productive new team members.'),

-- 10. Professional Self-Assessment
(10, 'Use self-assessment techniques to identify personal barriers.'),
(10, 'Transform self-reflection into actionable improvement plans.'),
(10, 'Develop clear and measurable growth objectives.'),
(10, 'Improve decision-making through deeper self-awareness.'),
(10, 'Seek constructive feedback to enhance accountability.'),
(10, 'Build confidence and advance your career strategically.'),
(10, 'Turn hidden patterns into opportunities for growth.'),
(10, 'Design a personalized self-development roadmap.'),
(10, 'Strengthen both professional and personal resilience.'),
(10, 'Achieve breakthroughs by aligning mindset and action.'),

-- 11. Establishing Continuous Business Excellence
(11, 'Embed a culture of excellence across your organization.'),
(11, 'Align teams using clear goals and accountability models.'),
(11, 'Streamline communication to improve collaboration and results.'),
(11, 'Apply powerful frameworks to drive continuous improvement.'),
(11, 'Establish robust KPIs and feedback loops for growth.'),
(11, 'Overcome resistance to change and build momentum.'),
(11, 'Navigate structural challenges to maintain agility.'),
(11, 'Integrate excellence practices into daily business rhythm.'),
(11, 'Create systems that support sustainable high performance.'),
(11, 'Transform your organization into a competitive, resilient enterprise.'),

-- 12. High-Performing Teams and Systems
(12, 'Design structured, high-performing teams that drive success.'),
(12, 'Clarify team roles and eliminate organizational silos.'),
(12, 'Improve cross-functional collaboration for better outcomes.'),
(12, 'Establish strong accountability systems and performance metrics.'),
(12, 'Develop effective conflict resolution and meeting frameworks.'),
(12, 'Optimize systems for scalability and organizational agility.'),
(12, 'Diagnose and solve structural bottlenecks.'),
(12, 'Align team structures with strategic organizational goals.'),
(12, 'Create sustainable systems to support long-term growth.'),
(12, 'Empower teams to continuously improve and excel.');