INSERT INTO course (title_short,
                    title,
                    description_short,
                    description,
                    description_long,
                    difficulty,
                    duration_hours,
                    price,
                    rating,
                    rating_count,
                    topic,
                    image_url,
                    color)
VALUES
    (
        'Foundations for a Successful Business & Career',
        'Building New Paradigm / Perception & Perspective as Foundations for a Successful Business and Professional Career',
        'Understand how paradigms, perception, and perspective shape your business and career success.',
        'Explore the concept of paradigms and how perception and perspective influence your progress in business and professional life. Learn why incorrect use of perception and perspective can hinder your growth.',
        'This course delves into the foundational concepts of paradigms, perception, and perspective as critical factors in business and career development. You will learn what a paradigm is, how perception and perspective are interconnected, and why changing one requires changing the other. Understand the potential negative consequences of misused perception and perspective and how to harness them effectively for success.',
        'BEGINNER',
        3,
        0,
        47,
        10,
        'Business & Career Development',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751286550/Foundations_for_a_Successful_Business_Career_k8vcuu.jpg',
        '#02C2FF'
    ),
    (
        'From Manager to Leader',
        'From Manager to Leader: Empowering People, Managing Processes',
        'Transform your managerial skills into effective leadership.',
        'Learn to lead people and manage processes with proven leadership tools and models.',
        'This course is designed for managers who want to become impactful leaders. It covers the core principles of leadership such as the 3xH’s of generative leadership, the difference between responsibility and guilt, communication strategies, feedback, and models like AB, Min/Max, and SMART objectives. Gain the mindset and practical tools to lead teams effectively, break silos, delegate with confidence, and mentor others.',
        'INTERMEDIATE',
        3,
        29,
        48,
        10,
        'Leadership & Management',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/From_Manager_to_Leader_-_Empowering_People_Managing_Processes_vgoyoh.webp',
        '#19C6D6'
        ),
       (
        'Business Transformation Blueprint',
        'Business Transformation Blueprint: Crafting the Path to Success',
        'Design and implement successful business transformations.',
        'Master the framework for guiding organizations through structured, sustainable transformation.',
        'This course provides a complete blueprint for driving successful business transformations. You’ll learn to identify when transformation is needed, and why following the proper sequence of steps is critical. We explore the role of middle management, the six core stages of transformation (from purpose to KPIs), and how to establish agile and resilient structures. You’ll also develop a new paradigm and perspective to boost your business’s STABILITY, AGILITY, RESILIENCE, and SUSTAINABILITY.',
        'ADVANCED',
        5.5,
        54,
        49,
        10,
        'Business Strategy & Transformation',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Business_Transformation_Blueprint_-_Crafting_the_Path_to_Success_aimssk.jpg',
        '#1FB0C3'),
       (
           'SME Business Roadmap',
        'Business Roadmap for SME’s: A Step-by-Step Guide for Establishing Core Business Foundations for Sustainable Growth',
        'Step-by-step guidance for SMEs to build solid business foundations.',
        'Cut through the noise and build sustainable business foundations with clarity and confidence.',
        'In today’s world of overwhelming information, especially around business growth, marketing, and sales strategies, it’s difficult to know where to begin. This course helps small and medium-sized businesses eliminate that confusion by providing a structured, step-by-step roadmap for building strong business foundations. Through a new paradigm and broadened perspective, you’ll increase your STABILITY, AGILITY, RESILIENCE, and SUSTAINABILITY while gaining clarity on what truly matters for long-term growth.',
        'INTERMEDIATE',
        6,
        35,
        49,
        10,
        'Entrepreneurship & SME Growth',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Business_Roadmap_for_SME_s_-_A_Step-by-Step_Guide_for_Establishing_Core_Business_Foundations_for_Sustainable_Growth_qeejox.jpg',
        '#002E5D'),
       (
           'Sales Masterclass',
        'Sales Masterclass: Leadership, Communication, and Modern Sales Process',
        'Master modern sales strategies, leadership, and communication.',
        'A complete guide to building elite sales skills, behaviors, and mindset.',
        'This comprehensive masterclass is designed for sales professionals who want to excel in today’s fast-paced and client-centric environment. Learn the role of frontline salespeople, how to build team synergy, and understand the critical difference between being responsible and feeling guilty. Explore how silos hurt sales, how to manage time effectively, and what truly defines high-performance behavior. Master modern sales and negotiation techniques, improve communication and decision-making, and learn to lead with clarity and confidence. Includes practical tools like the AB model and marketing techniques tailored for salespeople.',
        'ADVANCED',
        4,
        29,
        47,
        10,
        'Sales & Communication',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Sales_Masterclass_-_Leadership_Communication_and_Modern_Sales_Process_v74qdh.webp',
        '#034D4C'),
       (
           'Mastering Success Skills',
        'From Good to Extraordinary: Mastering Skills for Success',
        'Unlock your full potential with practical skills for extraordinary success.',
        'A holistic course for professionals aiming to elevate their effectiveness and mindset.',
        'This course is built for individuals who want to go from good to extraordinary in their personal and professional lives. You’ll explore key topics like perception, time management, managing expectations, and setting smart priorities. Learn and apply powerful tools like the AB and Min/Max models, the SMART objectives model, and the method of deduction. Develop cognitive skills, improve communication maturity, and boost your efficiency in meetings, decision-making, and real-world interactions. Focused on practical results, not just theory.',
        'INTERMEDIATE',
        6,
        35,
        48,
        10,
        'Personal Development & Productivity',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751032528/From_Good_to_Extraordinary_-_Mastering_Skills_for_Success_fm0io9.webp',
        '#D0B8A3'),
       (
           'Winning Markets in 3 Steps',
        'Winning Markets in 3 Steps: Building a Clear Go-to-Market Strategy',
        'Build a clear, effective go-to-market strategy in just 3 steps.',
        'Learn to target the right clients and approach the market with clarity and confidence.',
        'Without a clear marketing strategy, businesses often drift without direction. This course shows you how to avoid that by creating a precise go-to-market strategy in 3 steps. Define your ideal target client using 8 key characteristics: needs, wants, expectations, challenges, fears, intentions, prejudices, and opportunities. Learn when, where, and how to reach your audience, using tools like the AB model and a quantification method for negotiation and sales. Includes real-world examples to help you implement a clear, winning strategy.',
        'INTERMEDIATE',
        5,
        29,
        49,
        10,
        'Market Strategy',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Winning_Markets_in_3_Steps_-_Building_a_Clear_Go-to-Market_Strategy_vayg15.png',
        '#FF6F61'),
       (
           'How to Create Added Value',
        'Creating Added Value: How to Offer Solutions/Concepts, Instead of Services',
        'Shift from selling services to offering impactful solutions and concepts.',
        'Learn how to transition from offering services to delivering real value through solutions and long-term concepts.',
        'In this course, you’ll learn how to move beyond just offering products or services by creating added value through solutions and concepts. Understand the importance of knowing your target audience, identifying the problems your offering solves, and crafting offers that connect deeply with client needs. We’ll explore the difference between selling a service vs. a solution, and what it means to go a step further into creating a long-term concept. Includes real-world examples like the Nescafe Frape concept to bring theory to life.',
        'INTERMEDIATE',
        3.5,
        29,
        49,
        10,
        'Value Creation & Strategic Marketing',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Creating_Added_Value_-_How_to_Offer_SolutionsConcepts_Instead_of_Services_z9fs3c.png',
        '#F5AD01'),
       (
        'Seamless Onboarding Strategy',
        'Onboarding Fundamentals: How to Successfully Incorporate New Employees',
        'Master the essentials of onboarding to boost retention and employee satisfaction.',
        'Learn how to create a structured onboarding experience that accelerates productivity and ensures long-term success.',
        'This course dives into the core principles of effective onboarding. You’ll learn how a well-designed onboarding process can significantly improve employee retention, boost engagement, and enhance workplace satisfaction. Discover how to help new employees smoothly integrate into company culture, quickly understand their roles, and feel empowered from day one. Practical strategies, examples, and onboarding templates are included to help you implement a seamless onboarding journey.',
        'BEGINNER',
        3,
        25,
        48,
        10,
        'HR & Talent Development',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Onboarding_Fundamentals_-_How_to_Successfully_Incorporate_New_Employees_bksbad.png',
        '#008CC2'),
       (
        'Growth Through Self-Assessment',
        'Professional Self-Assessment: Identify Barriers Holding You Back & Areas for Improvement',
        'Use self-assessment tools to unlock growth and overcome personal barriers.',
        'Gain insight into your professional strengths, weaknesses, and areas for growth using proven self-assessment techniques.',
        'This course provides practical tools and frameworks to help you evaluate your professional performance and identify what’s holding you back. You’ll explore techniques like performance and need assessments, and learn to apply the method of deduction to draw clear conclusions about your development. Emphasis is placed on the role of efficiency and practical application in everyday work. Ideal for professionals looking to grow in self-awareness, accountability, and effectiveness.',
        'BEGINNER',
        2.5,
        25,
        47,
        10,
        'Personal Growth & Career Development',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/Professional_Self-Assessment_-_Identify_Barriers_Holding_You_Back_Areas_for_Improvement_tiyydc.jpg',
        '#CC6232'),
       (
        'Business Excellence Blueprint',
        'Establishing Continuous Business Excellence in Your Company',
        'Create a high-performance culture through proven excellence frameworks.',
        'Learn how to implement continuous improvement models to optimize operations, team alignment, and long-term success.',
        'This course is designed for professionals and leaders who want to embed a culture of excellence within their organization. You’ll explore powerful models such as the Effective Meetings Model, AB model, DF model, and pre/post evaluation frameworks. Learn how to map and address organizational disproportions and improve performance across all departments. By the end, you’ll be equipped with tools to drive consistency, accountability, and strategic growth across your company.',
        'ADVANCED',
        4,
        39,
        49,
        10,
        'Operational Excellence & Leadership',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028998/Establishing_Continuous_Business_Excellence_in_Your_Company_g3yvao.png',
        '#18898D'),
       (
        'Organizational Success Through Structure',
        'High-Performing Teams and Systems: Organizational Success Through Structure',
        'Build efficient, structured teams and systems that drive sustainable organizational success.',
        'Explore how to structure your teams and systems to optimize performance, efficiency, and collaboration across your organization.',
        'This course focuses on creating high-performing teams by implementing structured systems and eliminating inefficiencies. Learn how to apply a systematic approach to team organization, overcome the pitfalls of working in silos, and increase alignment through effective meetings, communication, confrontation, and decision-making practices. Ideal for team leaders and managers seeking a structured path to operational excellence.',
        'INTERMEDIATE',
        3.5,
        32,
        48,
        10,
        'Team Management & Organizational Structure',
        'https://res.cloudinary.com/dwlevfwtt/image/upload/v1751028999/High-Performing_Teams_and_Systems_-_Organizational_Success_Through_Structure_b6jvm5.jpg',
        '#FF9503');

INSERT INTO course_skills_gained (course_id, skills_gained) VALUES
-- 1. From Manager to Leader
(1, 'LEADERSHIP'),
(1, 'DELEGATION'),
(1, 'DECISION_MAKING'),
(1, 'PEOPLE_MANAGEMENT'),

-- 2. Business Transformation Blueprint
(2, 'STRATEGIC_PLANNING'),
(2, 'CHANGE_MANAGEMENT'),
(2, 'PROJECT_MANAGEMENT'),
(2, 'RISK_MANAGEMENT'),

-- 3. Business Roadmap for SME’s
(3, 'BUSINESS_MODEL_CREATION'),
(3, 'STRATEGIC_THINKING'),
(3, 'OPERATION_MANAGEMENT'),

-- 4. Sales Masterclass
(4, 'SALES'),
(4, 'COMMUNICATION'),
(4, 'NEGOTIATION'),
(4, 'LEADERSHIP'),

-- 5. From Good to Extraordinary
(5, 'COMMUNICATION'),
(5, 'DECISION_MAKING'),
(5, 'CRITICAL_THINKING'),
(5, 'EMOTIONAL_INTELLIGENCE'),

-- 6. Winning Markets in 3 Steps
(6, 'MARKETING'),
(6, 'SALES'),
(6, 'STRATEGIC_THINKING'),

-- 7. Creating Added Value
(7, 'OPPORTUNITY_IDENTIFICATION'),
(7, 'INNOVATION_MANAGEMENT'),
(7, 'MARKETING'),

-- 8. Onboarding Fundamentals
(8, 'PEOPLE_MANAGEMENT'),
(8, 'TEAM_BUILDING'),
(8, 'COMMUNICATION'),

-- 9. Professional Self-Assessment
(9, 'EMOTIONAL_INTELLIGENCE'),
(9, 'CRITICAL_THINKING'),
(9, 'COMMUNICATION'),

-- 10. Establishing Continuous Business Excellence
(10, 'PROJECT_MANAGEMENT'),
(10, 'PERFORMANCE_EVALUATION'),
(10, 'CHANGE_MANAGEMENT'),
(10, 'STRATEGIC_PLANNING'),

-- 11. High-Performing Teams and Systems
(11, 'TEAM_BUILDING'),
(11, 'OPERATION_MANAGEMENT'),
(11, 'PEOPLE_MANAGEMENT'),
(11, 'PERFORMANCE_EVALUATION');


INSERT INTO course_what_will_be_learned (course_id, what_will_be_learned) VALUES
-- 1. From Manager to Leader
(1, 'LEADERSHIP'),
(1, 'MANAGEMENT'),
(1, 'COMMUNICATION'),
(1, 'TEAM_DEVELOPMENT'),
(1, 'DECISION_MAKING'),

-- 2. Business Transformation Blueprint
(2, 'BUSINESS_TRANSFORMATION'),
(2, 'DIGITAL_TRANSFORMATION'),
(2, 'CHANGE_MANAGEMENT'),
(2, 'STRATEGIC_PLANNING'),
(2, 'AGILITY'),

-- 3. Business Roadmap for SME’s
(3, 'ENTREPRENEURSHIP'),
(3, 'STARTUP_METHODS'),
(3, 'BUSINESS_TRANSFORMATION'),
(3, 'STRATEGIC_PLANNING'),
(3, 'OPERATIONAL_EXCELLENCE'),

-- 4. Sales Masterclass
(4, 'SALES_STRATEGIES'),
(4, 'NEGOTIATION'),
(4, 'LEADERSHIP'),
(4, 'COMMUNICATION'),
(4, 'CLIENT_RELATIONSHIPS'),

-- 5. From Good to Extraordinary
(5, 'PERSONAL_GROWTH'),
(5, 'LEADERSHIP'),
(5, 'COMMUNICATION'),
(5, 'TIME_MANAGEMENT'),
(5, 'DECISION_MAKING'),

-- 6. Winning Markets in 3 Steps
(6, 'SALES_STRATEGIES'),
(6, 'MARKETING'),
(6, 'GO_TO_MARKET_STRATEGY'),
(6, 'CLIENT_TARGETING'),

-- 7. Creating Added Value
(7, 'MARKETING'),
(7, 'SALES'),
(7, 'VALUE_CREATION'),
(7, 'BUSINESS_INNOVATION'),

-- 8. Onboarding Fundamentals
(8, 'HR'),
(8, 'MANAGEMENT'),
(8, 'LEADERSHIP'),
(8, 'CULTURE_INTEGRATION'),

-- 9. Professional Self-Assessment
(9, 'PERSONAL_GROWTH'),
(9, 'LEADERSHIP'),
(9, 'SELF_AWARENESS'),
(9, 'PERFORMANCE_IMPROVEMENT'),

-- 10. Establishing Continuous Business Excellence
(10, 'MANAGEMENT'),
(10, 'BUSINESS_TRANSFORMATION'),
(10, 'CONTINUOUS_IMPROVEMENT'),
(10, 'STRATEGIC_PLANNING'),
(10, 'AGILITY'),

-- 11. High-Performing Teams and Systems
(11, 'MANAGEMENT'),
(11, 'LEADERSHIP'),
(11, 'BUSINESS_TRANSFORMATION'),
(11, 'TEAM_OPTIMIZATION'),
(11, 'SYSTEM_DESIGN');
